/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyFindNode
extends DHTUDPPacketReply {
    private DHTTransportContact[] contacts;
    private int random_id;
    private int node_status = -1;
    private int estimated_dht_size;

    public DHTUDPPacketReplyFindNode(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(dHTTransportUDPImpl, 1029, n, l, dHTTransportContact, dHTTransportContact2);
    }

    protected DHTUDPPacketReplyFindNode(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, 1029, n);
        if (this.getProtocolVersion() >= 7) {
            this.random_id = dataInputStream.readInt();
        }
        if (this.getProtocolVersion() >= 12) {
            this.node_status = dataInputStream.readInt();
        }
        if (this.getProtocolVersion() >= 13) {
            this.estimated_dht_size = dataInputStream.readInt();
        }
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.deserialiseVivaldi(this, dataInputStream);
        }
        this.contacts = DHTUDPUtils.deserialiseContacts(this.getTransport(), dataInputStream);
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.getProtocolVersion() >= 7) {
            dataOutputStream.writeInt(this.random_id);
        }
        if (this.getProtocolVersion() >= 12) {
            dataOutputStream.writeInt(this.node_status);
        }
        if (this.getProtocolVersion() >= 13) {
            dataOutputStream.writeInt(this.estimated_dht_size);
        }
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.serialiseVivaldi(this, dataOutputStream);
        }
        DHTUDPUtils.serialiseContacts(dataOutputStream, this.contacts);
    }

    protected void setContacts(DHTTransportContact[] dHTTransportContactArray) {
        this.contacts = dHTTransportContactArray;
    }

    protected void setRandomID(int n) {
        this.random_id = n;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setNodeStatus(int n) {
        this.node_status = n;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setEstimatedDHTSize(int n) {
        this.estimated_dht_size = n;
    }

    protected int getEstimatedDHTSize() {
        return this.estimated_dht_size;
    }

    protected DHTTransportContact[] getContacts() {
        return this.contacts;
    }

    public String getString() {
        return super.getString() + ",contacts=" + (this.contacts == null ? "null" : "" + this.contacts.length);
    }
}

