/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;

public class DHTUDPPacketReplyError
extends DHTUDPPacketReply {
    public static final int ET_UNKNOWN = 0;
    public static final int ET_ORIGINATOR_ADDRESS_WRONG = 1;
    public static final int ET_KEY_BLOCKED = 2;
    private int error_type = 0;
    private InetSocketAddress originator_address;
    private byte[] key_block_request;
    private byte[] key_block_signature;

    public DHTUDPPacketReplyError(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(dHTTransportUDPImpl, 1032, n, l, dHTTransportContact, dHTTransportContact2);
    }

    protected DHTUDPPacketReplyError(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, 1032, n);
        this.error_type = dataInputStream.readInt();
        if (this.error_type == 1) {
            this.originator_address = DHTUDPUtils.deserialiseAddress(dataInputStream);
        } else if (this.error_type == 2) {
            this.key_block_request = DHTUDPUtils.deserialiseByteArray(dataInputStream, 255);
            this.key_block_signature = DHTUDPUtils.deserialiseByteArray(dataInputStream, 65535);
        }
    }

    protected void setErrorType(int n) {
        this.error_type = n;
    }

    protected int getErrorType() {
        return this.error_type;
    }

    protected void setOriginatingAddress(InetSocketAddress inetSocketAddress) {
        this.originator_address = inetSocketAddress;
    }

    protected InetSocketAddress getOriginatingAddress() {
        return this.originator_address;
    }

    protected void setKeyBlockDetails(byte[] byArray, byte[] byArray2) {
        this.key_block_request = byArray;
        this.key_block_signature = byArray2;
    }

    protected byte[] getKeyBlockRequest() {
        return this.key_block_request;
    }

    protected byte[] getKeyBlockSignature() {
        return this.key_block_signature;
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeInt(this.error_type);
        if (this.error_type == 1) {
            try {
                DHTUDPUtils.serialiseAddress(dataOutputStream, this.originator_address);
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
                throw new IOException(dHTTransportException.getMessage());
            }
        } else if (this.error_type == 2) {
            DHTUDPUtils.serialiseByteArray(dataOutputStream, this.key_block_request, 255);
            DHTUDPUtils.serialiseByteArray(dataOutputStream, this.key_block_signature, 65535);
        }
    }
}

