/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketData
extends DHTUDPPacketRequest {
    protected static final byte PT_READ_REQUEST = 0;
    protected static final byte PT_READ_REPLY = 1;
    protected static final byte PT_WRITE_REQUEST = 2;
    protected static final byte PT_WRITE_REPLY = 3;
    private byte packet_type;
    private byte[] transfer_key;
    private byte[] key;
    private byte[] data;
    private int start_position;
    private int length;
    private int total_length;
    public static int MAX_DATA_SIZE = 1321;

    public DHTUDPPacketData(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1035, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketData(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1035, l, n);
        this.packet_type = dataInputStream.readByte();
        this.transfer_key = DHTUDPUtils.deserialiseByteArray(dataInputStream, 64);
        int n2 = this.getProtocolVersion() >= 24 ? 255 : 64;
        this.key = DHTUDPUtils.deserialiseByteArray(dataInputStream, n2);
        this.start_position = dataInputStream.readInt();
        this.length = dataInputStream.readInt();
        this.total_length = dataInputStream.readInt();
        this.data = DHTUDPUtils.deserialiseByteArray(dataInputStream, 65535);
        super.postDeserialise(dataInputStream);
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeByte(this.packet_type);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.transfer_key, 64);
        int n = this.getProtocolVersion() >= 24 ? 255 : 64;
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.key, n);
        dataOutputStream.writeInt(this.start_position);
        dataOutputStream.writeInt(this.length);
        dataOutputStream.writeInt(this.total_length);
        if (this.data.length > 0) {
            DHTUDPUtils.serialiseByteArray(dataOutputStream, this.data, this.start_position, this.length, 65535);
        } else {
            DHTUDPUtils.serialiseByteArray(dataOutputStream, this.data, 65535);
        }
        super.postSerialise(dataOutputStream);
    }

    public void setDetails(byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        this.packet_type = by;
        this.transfer_key = byArray;
        this.key = byArray2;
        this.data = byArray3;
        this.start_position = n;
        this.length = n2;
        this.total_length = n3;
    }

    public byte getPacketType() {
        return this.packet_type;
    }

    public byte[] getTransferKey() {
        return this.transfer_key;
    }

    public byte[] getRequestKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStartPosition() {
        return this.start_position;
    }

    public int getLength() {
        return this.length;
    }

    public int getTotalLength() {
        return this.total_length;
    }

    public String getString() {
        return super.getString() + "tk=" + DHTLog.getString2(this.transfer_key) + ",rk=" + DHTLog.getString2(this.key) + ",data=" + this.data.length + ",st=" + this.start_position + ",len=" + this.length + ",tot=" + this.total_length;
    }
}

