/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPositionProvider;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransportUDPContactImpl
implements DHTTransportUDPContact {
    public static final int NODE_STATUS_UNKNOWN = -1;
    public static final int NODE_STATUS_ROUTABLE = 1;
    private DHTTransportUDPImpl transport;
    private InetSocketAddress external_address;
    private InetSocketAddress transport_address;
    private byte[] id;
    private byte protocol_version;
    private int instance_id;
    private long skew;
    private int random_id;
    private int node_status = -1;
    private DHTNetworkPosition[] network_positions;

    protected DHTTransportUDPContactImpl(boolean bl, DHTTransportUDPImpl dHTTransportUDPImpl, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, byte by, int n, long l) throws DHTTransportException {
        this.transport = dHTTransportUDPImpl;
        this.transport_address = inetSocketAddress;
        this.external_address = inetSocketAddress2;
        this.protocol_version = by;
        if (this.transport_address.equals(this.external_address)) {
            this.external_address = this.transport_address;
        }
        this.instance_id = n;
        this.skew = l;
        if (this.transport_address == this.external_address || this.transport_address.getAddress().equals(this.external_address.getAddress())) {
            this.id = DHTUDPUtils.getNodeID(this.external_address, this.protocol_version);
        }
        this.createNetworkPositions(bl);
    }

    @Override
    public DHTTransport getTransport() {
        return this.transport;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected void setProtocolVersion(byte by) {
        this.protocol_version = by;
    }

    @Override
    public long getClockSkew() {
        return this.skew;
    }

    @Override
    public void setRandomID(int n) {
        this.random_id = n;
    }

    @Override
    public int getRandomID() {
        return this.random_id;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setNodeStatus(int n) {
        this.node_status = n;
    }

    @Override
    public boolean isValid() {
        return this.addressMatchesID() && !this.transport.invalidExternalAddress(this.external_address.getAddress());
    }

    protected boolean addressMatchesID() {
        return this.id != null;
    }

    @Override
    public InetSocketAddress getTransportAddress() {
        return this.transport_address;
    }

    @Override
    public void setTransportAddress(InetSocketAddress inetSocketAddress) {
        this.transport_address = inetSocketAddress;
    }

    @Override
    public InetSocketAddress getExternalAddress() {
        return this.external_address;
    }

    @Override
    public String getName() {
        return DHTLog.getString2(this.id);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getExternalAddress();
    }

    @Override
    public int getMaxFailForLiveCount() {
        return this.transport.getMaxFailForLiveCount();
    }

    @Override
    public int getMaxFailForUnknownCount() {
        return this.transport.getMaxFailForUnknownCount();
    }

    @Override
    public int getInstanceID() {
        return this.instance_id;
    }

    protected void setInstanceIDAndVersion(int n, byte by) {
        this.instance_id = n;
        if (by > this.protocol_version) {
            this.protocol_version = by;
        }
    }

    @Override
    public boolean isAlive(long l) {
        final AESemaphore aESemaphore = new AESemaphore("DHTTransportContact:alive");
        final boolean[] blArray = new boolean[]{false};
        try {
            this.sendPing(new DHTTransportReplyHandlerAdapter(){

                public void pingReply(DHTTransportContact dHTTransportContact) {
                    blArray[0] = true;
                    aESemaphore.release();
                }

                public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                    aESemaphore.release();
                }
            });
            aESemaphore.reserve(l);
            return blArray[0];
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void isAlive(DHTTransportReplyHandler dHTTransportReplyHandler, long l) {
        this.transport.sendPing(this, dHTTransportReplyHandler, l, 99);
    }

    @Override
    public void sendPing(DHTTransportReplyHandler dHTTransportReplyHandler) {
        this.transport.sendPing(this, dHTTransportReplyHandler);
    }

    @Override
    public void sendImmediatePing(DHTTransportReplyHandler dHTTransportReplyHandler, long l) {
        this.transport.sendImmediatePing(this, dHTTransportReplyHandler, l);
    }

    @Override
    public void sendStats(DHTTransportReplyHandler dHTTransportReplyHandler) {
        this.transport.sendStats(this, dHTTransportReplyHandler);
    }

    @Override
    public void sendStore(DHTTransportReplyHandler dHTTransportReplyHandler, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray, boolean bl) {
        this.transport.sendStore(this, dHTTransportReplyHandler, byArray, dHTTransportValueArray, bl ? 99 : 2);
    }

    @Override
    public void sendQueryStore(DHTTransportReplyHandler dHTTransportReplyHandler, int n, List<Object[]> list) {
        this.transport.sendQueryStore(this, dHTTransportReplyHandler, n, list);
    }

    @Override
    public void sendFindNode(DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray) {
        this.transport.sendFindNode(this, dHTTransportReplyHandler, byArray);
    }

    @Override
    public void sendFindValue(DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, int n, byte by) {
        this.transport.sendFindValue(this, dHTTransportReplyHandler, byArray, n, by);
    }

    @Override
    public void sendKeyBlock(final DHTTransportReplyHandler dHTTransportReplyHandler, final byte[] byArray, final byte[] byArray2) {
        this.sendFindNode(new DHTTransportReplyHandlerAdapter(){

            public void findNodeReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                DHTTransportUDPContactImpl.this.transport.sendKeyBlockRequest(DHTTransportUDPContactImpl.this, dHTTransportReplyHandler, byArray, byArray2);
            }

            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                dHTTransportReplyHandler.failed(dHTTransportContact, throwable);
            }
        }, new byte[0]);
    }

    @Override
    public DHTTransportFullStats getStats() {
        return this.transport.getFullStats(this);
    }

    @Override
    public byte[] getID() {
        if (this.id == null) {
            throw new RuntimeException("Invalid contact");
        }
        return this.id;
    }

    @Override
    public void exportContact(DataOutputStream dataOutputStream) throws IOException, DHTTransportException {
        this.transport.exportContact(this, dataOutputStream);
    }

    @Override
    public void remove() {
        this.transport.removeContact(this);
    }

    protected void setNetworkPositions(DHTNetworkPosition[] dHTNetworkPositionArray) {
        this.network_positions = dHTNetworkPositionArray;
    }

    @Override
    public void createNetworkPositions(boolean bl) {
        this.network_positions = DHTNetworkPositionManager.createPositions(this.id == null ? DHTUDPUtils.getBogusNodeID() : this.id, bl);
    }

    @Override
    public DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    @Override
    public DHTNetworkPosition getNetworkPosition(byte by) {
        for (int i = 0; i < this.network_positions.length; ++i) {
            if (this.network_positions[i].getPositionType() != by) continue;
            return this.network_positions[i];
        }
        return null;
    }

    @Override
    public String getString() {
        if (this.transport_address.equals(this.external_address)) {
            return DHTLog.getString2(this.id) + "[" + this.transport_address.toString() + ",V" + this.getProtocolVersion() + "]";
        }
        return DHTLog.getString2(this.id) + "[tran=" + this.transport_address.toString() + ",ext=" + this.external_address + ",V" + this.getProtocolVersion() + "]";
    }

    static {
        DHTNetworkPositionManager.registerProvider(new VivaldiPositionProvider());
    }
}

