/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.loopback;

import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackContactImpl;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackStatsImpl;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportRequestCounter;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportStatsImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransportLoopbackImpl
implements DHTTransport {
    public static byte VERSION = 1;
    public static int LATENCY = 0;
    public static int FAIL_PERCENTAGE = 0;
    private static long node_id_seed_next = 0L;
    private static Map node_map = new HashMap();
    private static List dispatch_queue = new ArrayList();
    private static AESemaphore dispatch_queue_sem = new AESemaphore("DHTTransportLoopback");
    private static AEMonitor class_mon = new AEMonitor("DHTTransportLoopback:class");
    private byte[] node_id;
    private DHTTransportContact local_contact;
    private int id_byte_length;
    private DHTTransportRequestHandler request_handler;
    private DHTTransportStatsImpl stats = new DHTTransportLoopbackStatsImpl(VERSION);
    private List listeners = new ArrayList();

    @Override
    public byte getProtocolVersion() {
        return VERSION;
    }

    @Override
    public int getNetwork() {
        return 0;
    }

    public static void setLatency(int n) {
        LATENCY = n;
    }

    public static void setFailPercentage(int n) {
        FAIL_PERCENTAGE = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTTransportStats getOverallStats() {
        try {
            class_mon.enter();
            DHTTransportLoopbackStatsImpl dHTTransportLoopbackStatsImpl = new DHTTransportLoopbackStatsImpl(VERSION);
            Iterator iterator = node_map.values().iterator();
            while (iterator.hasNext()) {
                dHTTransportLoopbackStatsImpl.add((DHTTransportStatsImpl)((DHTTransportLoopbackImpl)iterator.next()).getStats());
            }
            DHTTransportLoopbackStatsImpl dHTTransportLoopbackStatsImpl2 = dHTTransportLoopbackStatsImpl;
            Object var4_3 = null;
            class_mon.exit();
            return dHTTransportLoopbackStatsImpl2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTTransportLoopbackImpl(int n) {
        this.id_byte_length = n;
        try {
            class_mon.enter();
            byte[] byArray = new SHA1Simple().calculateHash(("" + node_id_seed_next++).getBytes());
            this.node_id = new byte[this.id_byte_length];
            System.arraycopy(byArray, 0, this.node_id, 0, this.id_byte_length);
            node_map.put(new HashWrapper(this.node_id), this);
            this.local_contact = new DHTTransportLoopbackContactImpl(this, this.node_id);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    @Override
    public DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    @Override
    public void setPort(int n) {
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public void setTimeout(long l) {
    }

    @Override
    public boolean isReachable() {
        return true;
    }

    @Override
    public DHTTransportContact[] getReachableContacts() {
        return new DHTTransportContact[0];
    }

    @Override
    public DHTTransportContact[] getRecentContacts() {
        return new DHTTransportContact[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DHTTransportLoopbackImpl findTarget(byte[] byArray) {
        try {
            class_mon.enter();
            DHTTransportLoopbackImpl dHTTransportLoopbackImpl = (DHTTransportLoopbackImpl)node_map.get(new HashWrapper(byArray));
            Object var4_3 = null;
            class_mon.exit();
            return dHTTransportLoopbackImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void setRequestHandler(DHTTransportRequestHandler dHTTransportRequestHandler) {
        this.request_handler = new DHTTransportRequestCounter(dHTTransportRequestHandler, this.stats);
    }

    protected DHTTransportRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    public void exportContact(DHTTransportContact dHTTransportContact, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(VERSION);
        dataOutputStream.writeInt(this.id_byte_length);
        dataOutputStream.write(dHTTransportContact.getID());
    }

    @Override
    public DHTTransportContact importContact(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != VERSION) {
            throw new IOException("Unsuported version");
        }
        int n2 = dataInputStream.readInt();
        if (n2 != this.id_byte_length) {
            throw new IOException("Imported contact has incorrect ID length");
        }
        byte[] byArray = new byte[this.id_byte_length];
        dataInputStream.read(byArray);
        DHTTransportLoopbackContactImpl dHTTransportLoopbackContactImpl = new DHTTransportLoopbackContactImpl(this, byArray);
        this.request_handler.contactImported(dHTTransportLoopbackContactImpl);
        return dHTTransportLoopbackContactImpl;
    }

    public void removeContact(DHTTransportContact dHTTransportContact) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(AERunnable aERunnable) {
        try {
            class_mon.enter();
            dispatch_queue.add(aERunnable);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        dispatch_queue_sem.release();
    }

    @Override
    public DHTTransportStats getStats() {
        return this.stats;
    }

    public void sendPing(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendPingSupport(dHTTransportContact, dHTTransportReplyHandler);
            }
        };
        this.run(aERunnable);
    }

    public void sendPingSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.pingSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.pingFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.pingOK();
            dHTTransportLoopbackImpl.getRequestHandler().pingRequest(new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id));
            dHTTransportReplyHandler.pingReply(dHTTransportContact, 0);
        }
    }

    public void sendKeyBlock(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler, final byte[] byArray, final byte[] byArray2) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendKeyBlockSupport(dHTTransportContact, dHTTransportReplyHandler, byArray, byArray2);
            }
        };
        this.run(aERunnable);
    }

    public void sendKeyBlockSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, byte[] byArray2) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.keyBlockSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.keyBlockFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.keyBlockOK();
            dHTTransportLoopbackImpl.getRequestHandler().keyBlockRequest(new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id), byArray, byArray2);
            dHTTransportReplyHandler.keyBlockReply(dHTTransportContact);
        }
    }

    public void sendStats(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendStatsSupport(dHTTransportContact, dHTTransportReplyHandler);
            }
        };
        this.run(aERunnable);
    }

    public void sendStatsSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.statsSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.statsFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.statsOK();
            DHTTransportFullStats dHTTransportFullStats = dHTTransportLoopbackImpl.getRequestHandler().statsRequest(new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id));
            dHTTransportReplyHandler.statsReply(dHTTransportContact, dHTTransportFullStats);
        }
    }

    public void sendStore(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler, final byte[][] byArray, final DHTTransportValue[][] dHTTransportValueArray, boolean bl) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendStoreSupport(dHTTransportContact, dHTTransportReplyHandler, byArray, dHTTransportValueArray);
            }
        };
        this.run(aERunnable);
    }

    public void sendStoreSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.storeSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.storeFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.storeOK();
            DHTTransportLoopbackContactImpl dHTTransportLoopbackContactImpl = new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id);
            dHTTransportLoopbackContactImpl.setRandomID(dHTTransportContact.getRandomID());
            DHTTransportStoreReply dHTTransportStoreReply = dHTTransportLoopbackImpl.getRequestHandler().storeRequest(dHTTransportLoopbackContactImpl, byArray, dHTTransportValueArray);
            if (dHTTransportStoreReply.blocked()) {
                dHTTransportReplyHandler.keyBlockRequest(dHTTransportContact, dHTTransportStoreReply.getBlockRequest(), dHTTransportStoreReply.getBlockSignature());
                dHTTransportReplyHandler.failed(dHTTransportContact, new Throwable("key blocked"));
            } else {
                dHTTransportReplyHandler.storeReply(dHTTransportContact, dHTTransportStoreReply.getDiversificationTypes());
            }
        }
    }

    public void sendQueryStore(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler, int n, List<Object[]> list) {
        dHTTransportReplyHandler.failed(dHTTransportContact, new Throwable("not implemented"));
    }

    public void sendFindNode(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler, final byte[] byArray) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendFindNodeSupport(dHTTransportContact, dHTTransportReplyHandler, byArray);
            }
        };
        this.run(aERunnable);
    }

    public void sendFindNodeSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.findNodeSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.findNodeFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.findNodeOK();
            DHTTransportLoopbackContactImpl dHTTransportLoopbackContactImpl = new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id);
            DHTTransportContact[] dHTTransportContactArray = dHTTransportLoopbackImpl.getRequestHandler().findNodeRequest(dHTTransportLoopbackContactImpl, byArray);
            dHTTransportContact.setRandomID(dHTTransportLoopbackContactImpl.getRandomID());
            DHTTransportContact[] dHTTransportContactArray2 = new DHTTransportContact[dHTTransportContactArray.length];
            for (int i = 0; i < dHTTransportContactArray.length; ++i) {
                dHTTransportContactArray2[i] = new DHTTransportLoopbackContactImpl(this, dHTTransportContactArray[i].getID());
            }
            dHTTransportReplyHandler.findNodeReply(dHTTransportContact, dHTTransportContactArray2);
        }
    }

    public void sendFindValue(final DHTTransportContact dHTTransportContact, final DHTTransportReplyHandler dHTTransportReplyHandler, final byte[] byArray, final int n, final byte by) {
        AERunnable aERunnable = new AERunnable(){

            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendFindValueSupport(dHTTransportContact, dHTTransportReplyHandler, byArray, n, by);
            }
        };
        this.run(aERunnable);
    }

    public void sendFindValueSupport(DHTTransportContact dHTTransportContact, DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, int n, byte by) {
        DHTTransportLoopbackImpl dHTTransportLoopbackImpl = this.findTarget(dHTTransportContact.getID());
        this.stats.findValueSent(null);
        if (dHTTransportLoopbackImpl == null || this.triggerFailure()) {
            this.stats.findValueFailed();
            dHTTransportReplyHandler.failed(dHTTransportContact, new Exception("failed"));
        } else {
            this.stats.findValueOK();
            DHTTransportFindValueReply dHTTransportFindValueReply = dHTTransportLoopbackImpl.getRequestHandler().findValueRequest(new DHTTransportLoopbackContactImpl(dHTTransportLoopbackImpl, this.node_id), byArray, n, by);
            if (dHTTransportFindValueReply.hit()) {
                dHTTransportReplyHandler.findValueReply(dHTTransportContact, dHTTransportFindValueReply.getValues(), dHTTransportFindValueReply.getDiversificationType(), false);
            } else if (dHTTransportFindValueReply.blocked()) {
                dHTTransportReplyHandler.keyBlockRequest(dHTTransportContact, dHTTransportFindValueReply.getBlockedKey(), dHTTransportFindValueReply.getBlockedSignature());
                dHTTransportReplyHandler.failed(dHTTransportContact, new Throwable("key blocked"));
            } else {
                DHTTransportContact[] dHTTransportContactArray = dHTTransportFindValueReply.getContacts();
                DHTTransportContact[] dHTTransportContactArray2 = new DHTTransportContact[dHTTransportContactArray.length];
                for (int i = 0; i < dHTTransportContactArray.length; ++i) {
                    dHTTransportContactArray2[i] = new DHTTransportLoopbackContactImpl(this, dHTTransportContactArray[i].getID());
                }
                dHTTransportReplyHandler.findValueReply(dHTTransportContact, dHTTransportContactArray2);
            }
        }
    }

    protected boolean triggerFailure() {
        return Math.random() * 100.0 < (double)FAIL_PERCENTAGE;
    }

    @Override
    public void registerTransferHandler(byte[] byArray, DHTTransportTransferHandler dHTTransportTransferHandler) {
    }

    @Override
    public byte[] readTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, long l) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public void writeTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, byte[] byArray3, long l) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public byte[] writeReadTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, long l) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public boolean supportsStorage() {
        return true;
    }

    @Override
    public void addListener(DHTTransportListener dHTTransportListener) {
        this.listeners.add(dHTTransportListener);
    }

    @Override
    public void removeListener(DHTTransportListener dHTTransportListener) {
        this.listeners.remove(dHTTransportListener);
    }

    static {
        AEThread aEThread = new AEThread("DHTTransportLoopback"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                while (true) {
                    Object var3_4;
                    Runnable runnable;
                    dispatch_queue_sem.reserve();
                    try {
                        class_mon.enter();
                        runnable = (Runnable)dispatch_queue.remove(0);
                        var3_4 = null;
                        class_mon.exit();
                    }
                    catch (Throwable throwable) {
                        var3_4 = null;
                        class_mon.exit();
                        throw throwable;
                    }
                    if (LATENCY > 0) {
                        try {
                            Thread.sleep(LATENCY);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    runnable.run();
                }
            }
        };
        aEThread.start();
    }
}

