/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloader;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderListener;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.services.UPnPOfflineDownloader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceOfflineDownloaderImpl
extends DeviceUPnPImpl
implements DeviceOfflineDownloader {
    public static final int UPDATE_MILLIS = 30000;
    public static final int UPDATE_TICKS = 6;
    public static final int UPDATE_SPACE_MILLIS = 180000;
    public static final int UPDATE_SPACE_TICKS = 36;
    public static final String client_id = ByteFormatter.encodeString(CryptoManagerFactory.getSingleton().getSecureID());
    private static final Object ERROR_KEY_OD = new Object();
    private volatile UPnPOfflineDownloader service;
    private volatile String service_ip;
    private volatile String manufacturer;
    private long start_time = SystemTime.getMonotonousTime();
    private volatile boolean update_space_outstanding = true;
    private volatile long space_on_device = -1L;
    private volatile boolean closing;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    final FrequencyLimitedDispatcher freq_lim_updater = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            DeviceOfflineDownloaderImpl.this.updateDownloads();
        }
    }, 5000);
    private boolean start_of_day = true;
    private int consec_errors = 0;
    private int consec_success = 0;
    private Map<String, OfflineDownload> offline_downloads = new HashMap<String, OfflineDownload>();
    private Map<String, TransferableDownload> transferable = new LinkedHashMap<String, TransferableDownload>();
    private TransferableDownload current_transfer;
    private boolean is_transferring;
    private CopyOnWriteList<DeviceOfflineDownloaderListener> listeners = new CopyOnWriteList();

    protected DeviceOfflineDownloaderImpl(DeviceManagerImpl deviceManagerImpl, UPnPDevice uPnPDevice, UPnPOfflineDownloader uPnPOfflineDownloader) {
        super(deviceManagerImpl, uPnPDevice, 5);
        this.setService(uPnPOfflineDownloader);
    }

    protected DeviceOfflineDownloaderImpl(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
        this.manufacturer = this.getPersistentStringProperty("od_manufacturer", "?");
    }

    @Override
    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (!super.updateFrom(deviceImpl, bl)) {
            return false;
        }
        if (!(deviceImpl instanceof DeviceOfflineDownloaderImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceOfflineDownloaderImpl deviceOfflineDownloaderImpl = (DeviceOfflineDownloaderImpl)deviceImpl;
        if (this.service == null && deviceOfflineDownloaderImpl.service != null) {
            this.setService(deviceOfflineDownloaderImpl.service);
            this.updateDownloads();
        }
        return true;
    }

    protected void setService(UPnPOfflineDownloader uPnPOfflineDownloader) {
        this.service = uPnPOfflineDownloader;
        UPnPRootDevice uPnPRootDevice = this.service.getGenericService().getDevice().getRootDevice();
        this.service_ip = uPnPRootDevice.getLocation().getHost();
        try {
            this.service_ip = InetAddress.getByName(this.service_ip).getHostAddress();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        Map map = uPnPRootDevice.getDiscoveryCache();
        if (map != null) {
            this.setPersistentMapProperty("od_upnp_cache", map);
        }
        this.manufacturer = uPnPRootDevice.getDevice().getManufacturer();
        this.setPersistentStringProperty("od_manufacturer", this.manufacturer);
        this.updateDownloads();
    }

    @Override
    protected void UPnPInitialised() {
        Map map;
        super.UPnPInitialised();
        if (this.service == null && (map = this.getPersistentMapProperty("od_upnp_cache", null)) != null) {
            this.getUPnPDeviceManager().injectDiscoveryCache(map);
        }
    }

    @Override
    protected void updateStatus(int n) {
        super.updateStatus(n);
        this.update_space_outstanding |= n % 36 == 0;
        if (n % 6 == 0) {
            this.updateDownloads();
        }
    }

    protected void checkConfig() {
        this.freq_lim_updater.dispatch();
    }

    protected void updateDownloads() {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (DeviceOfflineDownloaderImpl.this.dispatcher.getQueueSize() == 0) {
                    DeviceOfflineDownloaderImpl.this.updateDownloadsSupport();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void updateDownloadsSupport() {
        Object object9;
        Iterator iterator;
        ArrayList<Object> arrayList;
        ArrayList<OfflineDownload> arrayList2;
        ArrayList<OfflineDownload> arrayList3;
        boolean bl;
        AzureusCore azureusCore = this.getManager().getAzureusCore();
        if (azureusCore == null || this.closing) {
            return;
        }
        boolean bl2 = bl = SystemTime.getMonotonousTime() - this.start_time > 180000L;
        if (!this.isAlive() || this.service == null) {
            if (bl) {
                this.setError(ERROR_KEY_OD, MessageText.getString("device.od.error.notfound"));
            }
            return;
        }
        String string = null;
        boolean bl3 = false;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<String, TransferableDownload> hashMap2 = new HashMap<String, TransferableDownload>();
        try {
            block102: {
                void var15_24;
                int n;
                Object object2;
                Object[] objectArray;
                Object object3;
                Object object4;
                ArrayList arrayList4;
                Object object5;
                ArrayList<Object> arrayList5;
                Object object6;
                Map map;
                if (this.update_space_outstanding) {
                    try {
                        this.space_on_device = this.service.getFreeSpace(client_id);
                        this.update_space_outstanding = false;
                    }
                    catch (Throwable throwable) {
                        string = MessageText.getString("device.od.error.opfailexcep", new String[]{"GetFreeSpace", Debug.getNestedExceptionMessage(throwable)});
                        this.log("Failed to get free space", throwable);
                    }
                }
                if (this.space_on_device == 0L) {
                    string = MessageText.getString("device.od.error.nospace");
                    bl3 = true;
                }
                Map map2 = this.getPersistentMapProperty("od_state_cache", new HashMap());
                HashMap<Object, Object[]> hashMap3 = new HashMap<Object, Object[]>();
                GlobalManager globalManager = azureusCore.getGlobalManager();
                if (this.start_of_day) {
                    this.start_of_day = false;
                    map = this.getPersistentMapProperty("od_xfer_cache", new HashMap());
                    if (map.size() > 0) {
                        object6 = globalManager.getDownloadManagers();
                        arrayList5 = object6.iterator();
                        while (arrayList5.hasNext()) {
                            object5 = (DownloadManager)arrayList5.next();
                            if (!object5.isForceStart() || (arrayList4 = object5.getTorrent()) == null) continue;
                            try {
                                byte[] throwable = arrayList4.getHash();
                                String string2 = ByteFormatter.encodeString(throwable);
                                Map map3 = (Map)map.get(string2);
                                if (map3 == null || !map3.containsKey("f")) continue;
                                this.log((DownloadManager)object5, "Resetting force-start");
                                object5.setForceStart(false);
                            }
                            catch (Throwable bl4) {
                                Debug.printStackTrace(bl4);
                            }
                        }
                    }
                    globalManager.addListener(new GlobalManagerAdapter(){

                        public void downloadManagerAdded(DownloadManager downloadManager) {
                            DeviceOfflineDownloaderImpl.this.freq_lim_updater.dispatch();
                        }

                        public void downloadManagerRemoved(DownloadManager downloadManager) {
                            DeviceOfflineDownloaderImpl.this.freq_lim_updater.dispatch();
                        }
                    }, false);
                }
                if ((object6 = (map = this.getManager()).getOfflineDownlaoderManager()).isOfflineDownloadingEnabled() && this.isEnabled()) {
                    object5 = globalManager.getDownloadManagers();
                    arrayList4 = new ArrayList(object5.size());
                    Iterator iterator2 = object5.iterator();
                    while (iterator2.hasNext()) {
                        DownloadManager downloadManager = (DownloadManager)iterator2.next();
                        int n2 = downloadManager.getState();
                        if (n2 == 60 || n2 == 70 && !downloadManager.isPaused() || downloadManager.isDownloadComplete(false)) continue;
                        arrayList4.add(downloadManager);
                    }
                    arrayList5 = new ArrayList<Object>(arrayList4.size());
                    if (object6.getOfflineDownloadingIsAuto()) {
                        boolean downloadManager = object6.getOfflineDownloadingIncludePrivate();
                        if (downloadManager) {
                            arrayList5.addAll(arrayList4);
                        } else {
                            for (DownloadManager downloadManager2 : arrayList4) {
                                object4 = downloadManager2.getTorrent();
                                if (TorrentUtils.isReallyPrivate((TOTorrent)object4)) continue;
                                arrayList5.add(downloadManager2);
                            }
                        }
                    } else {
                        for (DownloadManager downloadManager : arrayList4) {
                            if (!object6.isManualDownload(PluginCoreUtils.wrap(downloadManager))) continue;
                            arrayList5.add(downloadManager);
                        }
                    }
                } else {
                    arrayList5 = new ArrayList();
                }
                object5 = new HashMap();
                for (DownloadManager downloadManager : arrayList5) {
                    TOTorrent tOTorrent = downloadManager.getTorrent();
                    if (tOTorrent == null) continue;
                    try {
                        int n3;
                        int n4;
                        Object[] objectArray2;
                        byte[] byArray = tOTorrent.getHash();
                        object4 = ByteFormatter.encodeString(byArray);
                        object3 = downloadManager.getDiskManager();
                        if (object3 == null) {
                            void var26_69;
                            objectArray = (byte[])map2.get(object4);
                            if (objectArray != null) {
                                hashMap3.put(object4, objectArray);
                                object5.put(downloadManager, objectArray);
                                continue;
                            }
                            objectArray2 = downloadManager.getDiskManagerFileInfo();
                            byte[] byArray2 = new byte[(tOTorrent.getNumberOfPieces() + 7) / 8];
                            n4 = 0;
                            object2 = objectArray2;
                            n3 = ((DiskManagerFileInfo[])object2).length;
                            boolean bl4 = false;
                            while (var26_69 < n3) {
                                DiskManagerFileInfo diskManagerFileInfo = object2[var26_69];
                                if (!diskManagerFileInfo.isSkipped()) {
                                    n = diskManagerFileInfo.getFirstPieceNumber();
                                    int n5 = n + diskManagerFileInfo.getNbPieces() - 1;
                                    int n6 = n / 8;
                                    int n7 = 0;
                                    for (int i = n; i <= n5; ++i) {
                                        n7 <<= 1;
                                        ++n7;
                                        ++n4;
                                        if (i % 8 != 7) continue;
                                        int n8 = n6++;
                                        byArray2[n8] = (byte)(byArray2[n8] | (byte)n7);
                                        n7 = 0;
                                    }
                                    if (n7 != 0) {
                                        int n9 = n6++;
                                        byArray2[n9] = (byte)(byArray2[n9] | (byte)(n7 << 8 - n5 % 8));
                                    }
                                }
                                ++var26_69;
                            }
                            if (n4 <= 0) continue;
                            hashMap3.put(object4, byArray2);
                            object5.put(downloadManager, byArray2);
                            continue;
                        }
                        objectArray = object3.getPieces();
                        objectArray2 = new byte[(objectArray.length + 7) / 8];
                        int n10 = 0;
                        n4 = 0;
                        int n11 = 0;
                        n3 = 0;
                        for (DiskManagerPiece diskManagerPiece : objectArray) {
                            n4 <<= 1;
                            if (diskManagerPiece.isNeeded() && !diskManagerPiece.isDone()) {
                                ++n4;
                                ++n3;
                            }
                            if (n11 % 8 == 7) {
                                objectArray2[n10++] = (DiskManagerFileInfo)((byte)n4);
                                n4 = 0;
                            }
                            ++n11;
                        }
                        if (n11 % 8 != 0) {
                            objectArray2[n10++] = (DiskManagerFileInfo)((byte)(n4 << 8 - n11 % 8));
                        }
                        if (n3 <= 0) continue;
                        hashMap3.put(object4, objectArray2);
                        object5.put(downloadManager, objectArray2);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
                this.setPersistentMapProperty("od_state_cache", hashMap3);
                arrayList4 = new ArrayList(object5.entrySet());
                Collections.sort(arrayList4, new Comparator<Map.Entry<DownloadManager, byte[]>>(){

                    @Override
                    public int compare(Map.Entry<DownloadManager, byte[]> entry, Map.Entry<DownloadManager, byte[]> entry2) {
                        return entry.getKey().getPosition() - entry2.getKey().getPosition();
                    }
                });
                String string3 = "";
                Iterator iterator3 = arrayList4.iterator();
                while (iterator3.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator3.next();
                    object4 = (DownloadManager)entry.getKey();
                    try {
                        object3 = ByteFormatter.encodeString(object4.getTorrent().getHash());
                        String string4 = (String)var15_24 + (var15_24.length() == 0 ? "" : ",") + (String)object3;
                        hashMap.put(object3, object4);
                    }
                    catch (Throwable throwable) {
                        this.log((DownloadManager)object4, "Failed to get download hash", throwable);
                        iterator3.remove();
                    }
                }
                try {
                    int n12;
                    String[] stringArray = this.service.setDownloads(client_id, (String)var15_24);
                    object4 = stringArray[0].trim();
                    object3 = stringArray[1];
                    if (!((String)object3).equals("OK")) {
                        string = MessageText.getString("device.od.error.opfailstatus", new String[]{"SetDownloads", object3});
                        throw new Exception("Failing result returned: " + (String)object3);
                    }
                    objectArray = ((String)object4).split(",");
                    int n13 = n12 = ((String)object4).length() == 0 ? 0 : objectArray.length;
                    if (n12 != arrayList4.size()) {
                        this.log("SetDownloads returned an invalid number of results (hashes=" + hashMap.size() + ",result=" + (String)object4 + ")");
                        break block102;
                    }
                    Iterator iterator4 = arrayList4.iterator();
                    int n14 = 0;
                    while (iterator4.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator4.next();
                        object2 = (DownloadManager)entry.getKey();
                        try {
                            int n15;
                            Object[] objectArray3;
                            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray;
                            Object object7;
                            TOTorrent tOTorrent = object2.getTorrent();
                            String string5 = ByteFormatter.encodeString(tOTorrent.getHash());
                            int n16 = Integer.parseInt((String)((Object)objectArray[n14++]));
                            n = 0;
                            if (n16 == 0) {
                                n = 1;
                            } else if (n16 == 1) {
                                try {
                                    if (PlatformTorrentUtils.isContent(tOTorrent, true) && (object7 = (Object)DownloadUtils.getTrackerExtensions(PluginCoreUtils.wrap((DownloadManager)object2))) != null && ((String)object7).length() > 0) {
                                        try {
                                            if (((String)object7).startsWith("&")) {
                                                object7 = ((String)object7).substring(1);
                                            }
                                            tOTorrent = TOTorrentFactory.deserialiseFromMap(tOTorrent.serialiseToMap());
                                            tOTorrent.setAnnounceURL(this.appendToURL(tOTorrent.getAnnounceURL(), (String)object7));
                                            tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
                                            for (TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray) {
                                                objectArray3 = tOTorrentAnnounceURLSet.getAnnounceURLs();
                                                for (n15 = 0; n15 < objectArray3.length; ++n15) {
                                                    objectArray3[n15] = (byte)this.appendToURL((URL)objectArray3[n15], (String)object7);
                                                }
                                            }
                                            tOTorrent.getAnnounceURLGroup().setAnnounceURLSets(tOTorrentAnnounceURLSetArray);
                                        }
                                        catch (Throwable throwable) {
                                            this.log("Torrent modification failed", throwable);
                                        }
                                    }
                                    object7 = this.addTorrent(string5, ByteFormatter.encodeStringFully(BEncoder.encode(tOTorrent.serialiseToMap())));
                                    this.log((DownloadManager)object2, "AddDownload succeeded");
                                    if (!((String)object7).equals("OK")) {
                                        string = MessageText.getString("device.od.error.opfailstatus", new String[]{"AddDownload", object7});
                                        throw new Exception("Failed to add download: " + (String)object7);
                                    }
                                    n = 1;
                                }
                                catch (Throwable throwable) {
                                    string = MessageText.getString("device.od.error.opfailexcep", new String[]{"AddDownload", Debug.getNestedExceptionMessage(throwable)});
                                    this.log((DownloadManager)object2, "Failed to add download", throwable);
                                }
                            } else {
                                string = MessageText.getString("device.od.error.opfailstatus", new String[]{"SetDownloads", String.valueOf(n16)});
                                this.log((DownloadManager)object2, "SetDownloads: error status returned - " + n16);
                            }
                            if (n == 0) continue;
                            try {
                                object7 = (byte[])entry.getValue();
                                tOTorrentAnnounceURLSetArray = ByteFormatter.encodeStringFully((byte[])object7);
                                Object[] objectArray4 = this.service.updateDownload(client_id, string5, (String)tOTorrentAnnounceURLSetArray);
                                String string6 = objectArray4[0];
                                String string7 = objectArray4[1];
                                if (!string7.equals("OK")) {
                                    string = MessageText.getString("device.od.error.opfailstatus", new String[]{"UpdateDownload", string7});
                                    throw new Exception("UpdateDownload: Failing result returned: " + string7);
                                }
                                int n17 = 0;
                                if (string6.length() > 0) {
                                    objectArray3 = ByteFormatter.decodeString(string6);
                                    if (objectArray3.length != ((Object)object7).length) {
                                        throw new Exception("UpdateDownload: Returned bitmap length invalid");
                                    }
                                    for (n15 = 0; n15 < ((Object)object7).length; ++n15) {
                                        int n18 = object7[n15] & objectArray3[n15] & 0xFF;
                                        if (n18 == 0) continue;
                                        for (int i = 0; i < 8; ++i) {
                                            if ((n18 & 1) != 0) {
                                                ++n17;
                                            }
                                            n18 >>= 1;
                                        }
                                    }
                                    if (n17 > 0) {
                                        long l = tOTorrent.getPieceLength();
                                        hashMap2.put(string5, new TransferableDownload((DownloadManager)object2, string5, (byte[])objectArray3, (long)n17 * l));
                                    }
                                }
                                if (n17 <= 0) continue;
                                this.log((DownloadManager)object2, "They have " + n17 + " pieces that we don't");
                            }
                            catch (Throwable throwable) {
                                string = MessageText.getString("device.od.error.opfailexcep", new String[]{"UpdateDownload", Debug.getNestedExceptionMessage(throwable)});
                                this.log((DownloadManager)object2, "UpdateDownload failed", throwable);
                            }
                        }
                        catch (Throwable throwable) {
                            this.log((DownloadManager)object2, "Processing failed", throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    string = MessageText.getString("device.od.error.opfailexcep", new String[]{"SetDownloads", Debug.getNestedExceptionMessage(throwable)});
                    this.log("SetDownloads failed", throwable);
                }
            }
            Object var40_101 = null;
            this.updateTransferable(hashMap2);
            arrayList3 = new ArrayList<OfflineDownload>();
            arrayList2 = new ArrayList<OfflineDownload>();
            arrayList = new ArrayList<Object>();
            iterator = this.offline_downloads;
        }
        catch (Throwable throwable) {
            Object object82;
            Object var40_102 = null;
            this.updateTransferable(hashMap2);
            ArrayList<OfflineDownload> arrayList4 = new ArrayList<OfflineDownload>();
            ArrayList<OfflineDownload> arrayList5 = new ArrayList<OfflineDownload>();
            ArrayList<Object> arrayList6 = new ArrayList<Object>();
            Iterator iterator5 = this.offline_downloads;
            synchronized (iterator5) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string8 = (String)entry.getKey();
                    if (this.offline_downloads.containsKey(string8)) continue;
                    object82 = new OfflineDownload((DownloadManager)entry.getValue());
                    this.offline_downloads.put(string8, (OfflineDownload)object82);
                    arrayList4.add((OfflineDownload)object82);
                }
                Iterator<Map.Entry<String, OfflineDownload>> iterator6 = this.offline_downloads.entrySet().iterator();
                while (iterator6.hasNext()) {
                    Map.Entry<String, OfflineDownload> entry = iterator6.next();
                    String string9 = entry.getKey();
                    object82 = entry.getValue();
                    if (hashMap.containsKey(string9)) {
                        TransferableDownload transferableDownload;
                        TransferableDownload transferableDownload2 = this.transferable.get(string9);
                        if (transferableDownload2 == (transferableDownload = ((OfflineDownload)object82).getTransferable())) continue;
                        if (!arrayList4.contains(object82)) {
                            arrayList6.add(object82);
                        }
                        ((OfflineDownload)object82).setTransferable(transferableDownload2);
                        continue;
                    }
                    iterator6.remove();
                    arrayList5.add((OfflineDownload)object82);
                }
            }
            for (OfflineDownload offlineDownload : arrayList4) {
                for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                    try {
                        deviceOfflineDownloaderListener.downloadAdded(offlineDownload);
                    }
                    catch (Throwable object82) {
                        Debug.out((Throwable)object82);
                    }
                }
            }
            for (OfflineDownload offlineDownload : arrayList6) {
                for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                    try {
                        deviceOfflineDownloaderListener.downloadChanged(offlineDownload);
                    }
                    catch (Throwable object82) {
                        Debug.out((Throwable)object82);
                    }
                }
            }
            for (OfflineDownload offlineDownload : arrayList5) {
                for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                    try {
                        deviceOfflineDownloaderListener.downloadRemoved(offlineDownload);
                    }
                    catch (Throwable object82) {
                        Debug.out((Throwable)object82);
                    }
                }
            }
            this.updateError(string, bl3);
            throw throwable;
        }
        synchronized (iterator) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string10 = (String)entry.getKey();
                if (this.offline_downloads.containsKey(string10)) continue;
                object9 = new OfflineDownload((DownloadManager)entry.getValue());
                this.offline_downloads.put(string10, (OfflineDownload)object9);
                arrayList3.add((OfflineDownload)object9);
            }
            Iterator<Map.Entry<String, OfflineDownload>> iterator7 = this.offline_downloads.entrySet().iterator();
            while (iterator7.hasNext()) {
                Map.Entry<String, OfflineDownload> entry = iterator7.next();
                String string11 = entry.getKey();
                object9 = entry.getValue();
                if (hashMap.containsKey(string11)) {
                    TransferableDownload transferableDownload;
                    TransferableDownload transferableDownload3 = this.transferable.get(string11);
                    if (transferableDownload3 == (transferableDownload = ((OfflineDownload)object9).getTransferable())) continue;
                    if (!arrayList3.contains(object9)) {
                        arrayList.add(object9);
                    }
                    ((OfflineDownload)object9).setTransferable(transferableDownload3);
                    continue;
                }
                iterator7.remove();
                arrayList2.add((OfflineDownload)object9);
            }
        }
        for (OfflineDownload offlineDownload : arrayList3) {
            for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                try {
                    deviceOfflineDownloaderListener.downloadAdded(offlineDownload);
                }
                catch (Throwable object9) {
                    Debug.out((Throwable)object9);
                }
            }
        }
        for (OfflineDownload offlineDownload : arrayList) {
            for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                try {
                    deviceOfflineDownloaderListener.downloadChanged(offlineDownload);
                }
                catch (Throwable object9) {
                    Debug.out((Throwable)object9);
                }
            }
        }
        for (OfflineDownload offlineDownload : arrayList2) {
            for (DeviceOfflineDownloaderListener deviceOfflineDownloaderListener : this.listeners) {
                try {
                    deviceOfflineDownloaderListener.downloadRemoved(offlineDownload);
                }
                catch (Throwable object9) {
                    Debug.out((Throwable)object9);
                }
            }
        }
        {
        }
        this.updateError(string, bl3);
    }

    private String addTorrent(String string, String string2) throws UPnPException {
        int n = 40960;
        int n2 = string2.length();
        if (n2 < n) {
            return this.service.addDownload(client_id, string, string2);
        }
        String string3 = "";
        int n3 = n2;
        for (int i = 0; i < n2; i += n) {
            int n4 = Math.min(n3, n);
            string3 = this.service.addDownloadChunked(client_id, string, string2.substring(i, i + n4), i, n2);
            n3 -= n4;
        }
        return string3;
    }

    protected void updateError(String string, boolean bl) {
        if (string == null) {
            this.setError(ERROR_KEY_OD, null);
            this.consec_errors = 0;
            ++this.consec_success;
        } else {
            try {
                if (!this.service.getGenericService().isConnectable()) {
                    string = MessageText.getString("device.od.error.notfound");
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            ++this.consec_errors;
            this.consec_success = 0;
            if (this.consec_errors > 2 || bl) {
                this.setError(ERROR_KEY_OD, string);
            }
        }
    }

    protected URL appendToURL(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.toExternalForm();
        string2 = string2.indexOf(63) == -1 ? string2 + "?" + string : string2 + "&" + string;
        return new URL(string2);
    }

    protected void updateTransferable(Map<String, TransferableDownload> map) {
        long l;
        long l2;
        Iterator<Map.Entry<String, TransferableDownload>> iterator = this.transferable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TransferableDownload> entry = iterator.next();
            if (map.containsKey(entry.getKey())) continue;
            TransferableDownload object2 = (TransferableDownload)entry.getValue();
            if (object2 == this.current_transfer) {
                this.current_transfer.deactivate();
                this.current_transfer = null;
            }
            iterator.remove();
        }
        for (TransferableDownload transferableDownload : map.values()) {
            String string = transferableDownload.getHash();
            if (this.transferable.containsKey(string)) continue;
            this.transferable.put(string, transferableDownload);
        }
        if (this.transferable.size() == 0) {
            if (this.is_transferring) {
                this.is_transferring = false;
                this.setBusy(false);
            }
            return;
        }
        if (!this.is_transferring) {
            this.is_transferring = true;
            this.setBusy(true);
        }
        if (this.current_transfer != null && this.transferable.size() > 0 && (l2 = (l = SystemTime.getMonotonousTime()) - this.current_transfer.getStartTime()) >= 30000L) {
            boolean bl = false;
            PEPeerManager pEPeerManager = this.current_transfer.getDownload().getPeerManager();
            if (pEPeerManager == null) {
                bl = true;
            } else if (l2 > 180000L) {
                List<PEPeer> list = pEPeerManager.getPeers(this.service_ip);
                if (list.size() == 0) {
                    bl = true;
                } else {
                    PEPeer pEPeer = list.get(0);
                    if (pEPeer.getStats().getDataReceiveRate() < 1024L) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.current_transfer.deactivate();
                this.current_transfer = null;
            }
        }
        if (this.current_transfer == null) {
            Iterator<TransferableDownload> iterator2 = this.transferable.values().iterator();
            this.current_transfer = iterator2.next();
            iterator2.remove();
            this.transferable.put(this.current_transfer.getHash(), this.current_transfer);
        }
        if (this.current_transfer != null) {
            int n;
            if (!this.current_transfer.isActive()) {
                this.current_transfer.activate();
            }
            if (this.current_transfer.isForced()) {
                HashMap hashMap = new HashMap();
                HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
                hashMap2.put("f", new Long(1L));
                hashMap.put(this.current_transfer.getHash(), hashMap2);
                this.setPersistentMapProperty("od_xfer_cache", hashMap);
            }
            DownloadManager downloadManager = this.current_transfer.getDownload();
            int n2 = this.current_transfer.getDataPort();
            if (n2 <= 0) {
                try {
                    String[] stringArray = this.service.startDownload(client_id, this.current_transfer.getHash());
                    String string = stringArray[1];
                    if (!string.equals("OK")) {
                        throw new Exception("Failing result returned: " + string);
                    }
                    n = Integer.parseInt(stringArray[0]);
                    this.log(downloadManager, "StartDownload succeeded - data port=" + n);
                }
                catch (Throwable throwable) {
                    this.log(downloadManager, "StartDownload failed", throwable);
                }
            }
            if (n > 0) {
                this.current_transfer.setDataPort(n);
            }
            final TransferableDownload transferableDownload = this.current_transfer;
            this.dispatcher.dispatch(new AERunnable(){
                private final int[] count = new int[]{0};

                public void runSupport() {
                    this.count[0] = this.count[0] + 1;
                    if (DeviceOfflineDownloaderImpl.this.current_transfer != transferableDownload || !transferableDownload.isActive()) {
                        return;
                    }
                    PEPeerManager pEPeerManager = transferableDownload.getDownload().getPeerManager();
                    if (pEPeerManager == null) {
                        return;
                    }
                    List<PEPeer> list = pEPeerManager.getPeers(DeviceOfflineDownloaderImpl.this.service_ip);
                    if (list.size() > 0) {
                        return;
                    }
                    LightHashMap lightHashMap = new LightHashMap();
                    lightHashMap.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                    pEPeerManager.addPeer(DeviceOfflineDownloaderImpl.this.service_ip, transferableDownload.getDataPort(), 0, false, lightHashMap);
                    if (this.count[0] < 3) {
                        final 5 var4_4 = this;
                        SimpleTimer.addEvent("OD:retry", SystemTime.getCurrentTime() + 5000L, new TimerEventPerformer(){

                            public void perform(TimerEvent timerEvent2) {
                                DeviceOfflineDownloaderImpl.this.dispatcher.dispatch(var4_4);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected void close() {
        super.close();
        final AESemaphore aESemaphore = new AESemaphore("DOD:closer");
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    DeviceOfflineDownloaderImpl.this.closing = true;
                    if (DeviceOfflineDownloaderImpl.this.service != null) {
                        try {
                            DeviceOfflineDownloaderImpl.this.service.activate(client_id);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    Object var3_2 = null;
                    aESemaphore.release();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    aESemaphore.release();
                    throw throwable;
                }
            }
        });
        aESemaphore.reserve(250L);
    }

    @Override
    public boolean isEnabled() {
        return this.getPersistentBooleanProperty("od_enabled", false);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setPersistentBooleanProperty("od_enabled", bl);
        if (bl) {
            this.freq_lim_updater.dispatch();
        }
    }

    @Override
    public boolean isAlive() {
        if (super.isAlive()) {
            return this.service.getGenericService().isConnectable();
        }
        return false;
    }

    @Override
    public boolean hasShownFTUX() {
        return this.getPersistentBooleanProperty("od_shown_ftux", false);
    }

    @Override
    public void setShownFTUX() {
        this.setPersistentBooleanProperty("od_shown_ftux", true);
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public long getSpaceAvailable(boolean bl) throws DeviceManagerException {
        if (this.space_on_device >= 0L && !bl) {
            return this.space_on_device;
        }
        if (this.service == null) {
            throw new DeviceManagerException("Device is not online");
        }
        try {
            this.space_on_device = this.service.getFreeSpace(client_id);
            this.update_space_outstanding = false;
            return this.space_on_device;
        }
        catch (Throwable throwable) {
            throw new DeviceManagerException("Failed to read available space", throwable);
        }
    }

    @Override
    public int getTransferingCount() {
        return this.transferable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceOfflineDownload[] getDownloads() {
        Map<String, OfflineDownload> map = this.offline_downloads;
        synchronized (map) {
            return this.offline_downloads.values().toArray(new DeviceOfflineDownload[this.offline_downloads.size()]);
        }
    }

    @Override
    public void addListener(DeviceOfflineDownloaderListener deviceOfflineDownloaderListener) {
        this.listeners.add(deviceOfflineDownloaderListener);
    }

    @Override
    public void removeListener(DeviceOfflineDownloaderListener deviceOfflineDownloaderListener) {
        this.listeners.remove(deviceOfflineDownloaderListener);
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        String string = "";
        if (this.space_on_device >= 0L) {
            string = DisplayFormatters.formatByteCountToKiBEtc(this.space_on_device);
        }
        this.addDP(list, "azbuddy.enabled", this.isEnabled());
        this.addDP(list, "device.od.space", string);
    }

    protected void log(DownloadManager downloadManager, String string) {
        this.log(downloadManager.getDisplayName() + ": " + string);
    }

    protected void log(DownloadManager downloadManager, String string, Throwable throwable) {
        this.log(downloadManager.getDisplayName() + ": " + string, throwable);
    }

    @Override
    protected void log(String string) {
        super.log("OfflineDownloader: " + string);
    }

    @Override
    protected void log(String string, Throwable throwable) {
        super.log("OfflineDownloader: " + string, throwable);
    }

    protected class TransferableDownload {
        private DownloadManager download;
        private String hash_str;
        private byte[] have_map;
        private boolean active;
        private long start_time;
        private boolean forced;
        private int data_port;
        private long transfer_size;
        private volatile long last_calc;
        private volatile long last_calc_time;

        protected TransferableDownload(DownloadManager downloadManager, String string, byte[] byArray, long l) {
            this.download = downloadManager;
            this.hash_str = string;
            this.have_map = byArray;
            this.last_calc = this.transfer_size = l;
        }

        protected long calcDiff() {
            long l = SystemTime.getMonotonousTime();
            if (l - this.last_calc_time < 2000L) {
                return this.last_calc;
            }
            DiskManager diskManager = this.download.getDiskManager();
            if (diskManager == null) {
                return this.last_calc;
            }
            DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
            int n = 0;
            int n2 = 0;
            long l2 = 0L;
            for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                if (i % 8 == 0) {
                    n2 = this.have_map[n++] & 0xFF;
                }
                if ((n2 & 0x80) != 0) {
                    DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                    boolean[] blArray = diskManagerPiece.getWritten();
                    if (blArray == null) {
                        if (!diskManagerPiece.isDone()) {
                            l2 += (long)diskManagerPiece.getLength();
                        }
                    } else {
                        for (int j = 0; j < blArray.length; ++j) {
                            if (blArray[j]) continue;
                            l2 += (long)diskManagerPiece.getBlockSize(j);
                        }
                    }
                }
                n2 <<= 1;
            }
            this.last_calc = l2;
            this.last_calc_time = l;
            return this.last_calc;
        }

        protected long getCurrentTransferSize() {
            return this.transfer_size;
        }

        protected long getRemaining() {
            return this.calcDiff();
        }

        protected long getStartTime() {
            return this.start_time;
        }

        protected boolean isForced() {
            return this.forced;
        }

        protected boolean isActive() {
            return this.active;
        }

        protected int getDataPort() {
            return this.data_port;
        }

        protected void setDataPort(int n) {
            this.data_port = n;
        }

        protected void activate() {
            this.active = true;
            this.start_time = SystemTime.getMonotonousTime();
            if (this.download.isForceStart()) {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Activating for transfer");
            } else {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Activating for transfer; setting force-start");
                this.forced = true;
                this.download.setForceStart(true);
            }
        }

        protected void deactivate() {
            this.active = false;
            if (this.forced) {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Deactivating for transfer; resetting force-start");
                this.download.setForceStart(false);
            } else {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Deactivating for transfer");
            }
            this.data_port = 0;
        }

        protected DownloadManager getDownload() {
            return this.download;
        }

        protected String getHash() {
            return this.hash_str;
        }

        protected byte[] getHaveMap() {
            return this.have_map;
        }
    }

    protected class OfflineDownload
    implements DeviceOfflineDownload {
        private DownloadManager core_download;
        private Download download;
        private TransferableDownload transferable;

        protected OfflineDownload(DownloadManager downloadManager) {
            this.core_download = downloadManager;
            this.download = PluginCoreUtils.wrap(this.core_download);
        }

        public Download getDownload() {
            return this.download;
        }

        public boolean isTransfering() {
            return this.transferable != null;
        }

        public long getCurrentTransferSize() {
            TransferableDownload transferableDownload = this.transferable;
            if (transferableDownload == null) {
                return 0L;
            }
            return transferableDownload.getCurrentTransferSize();
        }

        public long getRemaining() {
            TransferableDownload transferableDownload = this.transferable;
            if (transferableDownload == null) {
                return 0L;
            }
            return transferableDownload.getRemaining();
        }

        protected void setTransferable(TransferableDownload transferableDownload) {
            this.transferable = transferableDownload;
        }

        protected TransferableDownload getTransferable() {
            return this.transferable;
        }
    }
}

