/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderManager;
import com.aelitis.azureus.core.devices.DeviceSearchListener;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.impl.DeviceDriveManager;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerUPnPImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererManual;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererTemplateImpl;
import com.aelitis.azureus.core.devices.impl.DeviceOfflineDownloaderImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivoManager;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.devices.impl.DeviceiTunesManager;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.net.upnp.UPnPDevice;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class DeviceManagerImpl
implements DeviceManager,
DeviceOfflineDownloaderManager,
AEDiagnosticsEvidenceGenerator {
    private static final String LOGGER_NAME = "Devices";
    private static final String CONFIG_FILE = "devices.config";
    private static final String AUTO_SEARCH_CONFIG_KEY = "devices.config.auto_search";
    private static final String RSS_ENABLE_CONFIG_KEY = "devices.config.rss_enable";
    private static final String OD_ENABLED_CONFIG_KEY = "devices.config.od.enabled";
    private static final String OD_IS_AUTO_CONFIG_KEY = "devices.config.od.auto";
    private static final String OD_INCLUDE_PRIVATE_CONFIG_KEY = "devices.config.od.inc_priv";
    private static final String TRANSCODE_DIR_DEFAULT = "transcodes";
    private static final String CONFIG_DEFAULT_WORK_DIR = "devices.config.def_work_dir";
    protected static final int DEVICE_UPDATE_PERIOD = 5000;
    private static DeviceManagerImpl singleton;
    private AzureusCore azureus_core;
    private TorrentAttribute od_manual_ta;
    private List<DeviceImpl> device_list = new ArrayList<DeviceImpl>();
    private Map<String, DeviceImpl> device_map = new HashMap<String, DeviceImpl>();
    private DeviceTivoManager tivo_manager;
    private DeviceManagerUPnPImpl upnp_manager;
    private DeviceDriveManager drive_manager;
    private static final int LT_DEVICE_ADDED = 1;
    private static final int LT_DEVICE_CHANGED = 2;
    private static final int LT_DEVICE_ATTENTION = 3;
    private static final int LT_DEVICE_REMOVED = 4;
    private static final int LT_INITIALIZED = 5;
    private ListenerManager<DeviceManagerListener> listeners = ListenerManager.createAsyncManager("DM:ld", new ListenerManagerDispatcher<DeviceManagerListener>(){

        @Override
        public void dispatch(DeviceManagerListener deviceManagerListener, int n, Object object) {
            DeviceImpl deviceImpl = (DeviceImpl)object;
            switch (n) {
                case 1: {
                    deviceManagerListener.deviceAdded(deviceImpl);
                    break;
                }
                case 2: {
                    if (!this.deviceAdded(deviceImpl)) break;
                    deviceImpl.fireChanged();
                    deviceManagerListener.deviceChanged(deviceImpl);
                    break;
                }
                case 3: {
                    if (!this.deviceAdded(deviceImpl)) break;
                    deviceManagerListener.deviceAttentionRequest(deviceImpl);
                    break;
                }
                case 4: {
                    deviceManagerListener.deviceRemoved(deviceImpl);
                    break;
                }
                case 5: {
                    deviceManagerListener.deviceManagerLoaded();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean deviceAdded(Device device) {
            DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
            synchronized (deviceManagerImpl) {
                return DeviceManagerImpl.this.device_list.contains(device);
            }
        }
    });
    private boolean auto_search;
    private boolean od_enabled;
    private boolean od_is_auto;
    private boolean od_include_private;
    private boolean closing;
    private boolean config_unclean;
    private boolean config_dirty;
    private int explicit_search;
    private volatile TranscodeManagerImpl transcode_manager;
    private int getMimeType_fails;
    private Object logger_lock = new Object();
    private AEDiagnosticsLogger logger;
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(10000);
    private AESemaphore init_sem = new AESemaphore("dm:init");
    private volatile boolean initialized = false;

    public static void preInitialise() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceManager getSingleton() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (singleton == null) {
                singleton = new DeviceManagerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected DeviceManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore azureusCore) {
                DeviceManagerImpl.this.initWithCore(azureusCore);
            }
        });
    }

    private void ensureInitialised() {
        AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
        if (azureusCore.isStarted()) {
            this.initWithCore(azureusCore);
        }
        if (azureusCore.isInitThread()) {
            Debug.out("This is bad");
            this.initWithCore(azureusCore);
        }
        this.init_sem.reserve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWithCore(AzureusCore azureusCore) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.azureus_core != null) {
                return;
            }
            this.azureus_core = azureusCore;
        }
        try {
            this.od_manual_ta = PluginInitializer.getDefaultInterface().getTorrentManager().getPluginAttribute("device.manager.od.ta.manual");
            COConfigurationManager.addAndFireParameterListeners(new String[]{AUTO_SEARCH_CONFIG_KEY}, new ParameterListener(){

                public void parameterChanged(String string) {
                    DeviceManagerImpl.this.auto_search = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.AUTO_SEARCH_CONFIG_KEY, true);
                }
            });
            COConfigurationManager.addAndFireParameterListeners(new String[]{OD_ENABLED_CONFIG_KEY, OD_IS_AUTO_CONFIG_KEY, OD_INCLUDE_PRIVATE_CONFIG_KEY}, new ParameterListener(){

                public void parameterChanged(String string) {
                    boolean bl = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_ENABLED_CONFIG_KEY, true);
                    boolean bl2 = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_IS_AUTO_CONFIG_KEY, true);
                    boolean bl3 = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_INCLUDE_PRIVATE_CONFIG_KEY, false);
                    if (bl != DeviceManagerImpl.this.od_enabled || bl2 != DeviceManagerImpl.this.od_is_auto || bl3 != DeviceManagerImpl.this.od_include_private) {
                        DeviceManagerImpl.this.od_enabled = bl;
                        DeviceManagerImpl.this.od_is_auto = bl2;
                        DeviceManagerImpl.this.od_include_private = bl3;
                        DeviceManagerImpl.this.manageOD();
                    }
                }
            });
            this.tivo_manager = new DeviceTivoManager(this);
            this.upnp_manager = new DeviceManagerUPnPImpl(this);
            this.loadConfig();
            new DeviceiTunesManager(this);
            this.drive_manager = new DeviceDriveManager(this);
            this.transcode_manager = new TranscodeManagerImpl(this);
            azureusCore.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stopping(AzureusCore azureusCore) {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        DeviceImpl[] deviceImplArray;
                        if (DeviceManagerImpl.this.config_dirty || DeviceManagerImpl.this.config_unclean) {
                            DeviceManagerImpl.this.saveConfig();
                        }
                        DeviceManagerImpl.this.closing = true;
                        DeviceManagerImpl.this.transcode_manager.close();
                        for (DeviceImpl deviceImpl : deviceImplArray = DeviceManagerImpl.this.getDevices()) {
                            deviceImpl.close();
                        }
                    }
                }
            });
            this.upnp_manager.initialise();
            SimpleTimer.addPeriodicEvent("DeviceManager:update", 5000L, new TimerEventPerformer(){
                private int tick_count = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(TimerEvent timerEvent2) {
                    ArrayList arrayList;
                    ++this.tick_count;
                    DeviceManagerImpl.this.transcode_manager.updateStatus(this.tick_count);
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (DeviceManagerImpl.this.device_list.size() == 0) {
                            return;
                        }
                        arrayList = new ArrayList(DeviceManagerImpl.this.device_list);
                    }
                    for (DeviceImpl deviceImpl : arrayList) {
                        deviceImpl.updateStatus(this.tick_count);
                    }
                }
            });
            this.initialized = true;
            this.listeners.dispatch(5, null);
            Object var5_4 = null;
            this.init_sem.releaseForever();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.init_sem.releaseForever();
            throw throwable;
        }
    }

    protected void manageOD() {
        DeviceImpl[] deviceImplArray;
        for (DeviceImpl deviceImpl : deviceImplArray = this.getDevices()) {
            if (deviceImpl.getType() != 5) continue;
            ((DeviceOfflineDownloaderImpl)deviceImpl).checkConfig();
        }
    }

    protected void UPnPManagerStarted() {
        DeviceImpl[] deviceImplArray;
        this.tivo_manager.startUp();
        for (DeviceImpl deviceImpl : deviceImplArray = this.getDevices()) {
            if (!(deviceImpl instanceof DeviceUPnPImpl)) continue;
            ((DeviceUPnPImpl)deviceImpl).UPnPInitialised();
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected DeviceManagerUPnPImpl getUPnPManager() {
        return this.upnp_manager;
    }

    public boolean isTiVoEnabled() {
        return this.tivo_manager.isEnabled();
    }

    public void setTiVoEnabled(boolean bl) {
        this.tivo_manager.setEnabled(bl);
    }

    public DeviceTemplate[] getDeviceTemplates(int n) {
        if (this.transcode_manager == null || n != 3) {
            return new DeviceTemplate[0];
        }
        TranscodeProvider[] transcodeProviderArray = this.transcode_manager.getProviders();
        ArrayList<DeviceMediaRendererTemplateImpl> arrayList = new ArrayList<DeviceMediaRendererTemplateImpl>();
        for (TranscodeProvider transcodeProvider : transcodeProviderArray) {
            TranscodeProfile[] transcodeProfileArray = transcodeProvider.getProfiles();
            HashMap<String, DeviceMediaRendererTemplateImpl> hashMap = new HashMap<String, DeviceMediaRendererTemplateImpl>();
            for (TranscodeProfile transcodeProfile : transcodeProfileArray) {
                String string = transcodeProfile.getDeviceClassification();
                if (string.startsWith("apple.")) {
                    string = "apple.";
                }
                boolean bl = string.equals("sony.PS3") || string.equals("microsoft.XBox") || string.equals("apple.") || string.equals("nintendo.Wii") || string.equals("browser.generic");
                DeviceMediaRendererTemplateImpl deviceMediaRendererTemplateImpl = (DeviceMediaRendererTemplateImpl)hashMap.get(string);
                if (deviceMediaRendererTemplateImpl == null) {
                    deviceMediaRendererTemplateImpl = new DeviceMediaRendererTemplateImpl(this, string, bl);
                    hashMap.put(string, deviceMediaRendererTemplateImpl);
                    arrayList.add(deviceMediaRendererTemplateImpl);
                }
                deviceMediaRendererTemplateImpl.addProfile(transcodeProfile);
            }
        }
        return arrayList.toArray(new DeviceTemplate[arrayList.size()]);
    }

    public DeviceManager.DeviceManufacturer[] getDeviceManufacturers(int n) {
        DeviceTemplate[] deviceTemplateArray = this.getDeviceTemplates(n);
        HashMap<String, DeviceManufacturerImpl> hashMap = new HashMap<String, DeviceManufacturerImpl>();
        for (DeviceTemplate deviceTemplate : deviceTemplateArray) {
            if (deviceTemplate.getType() != n) continue;
            String string = deviceTemplate.getManufacturer();
            DeviceManufacturerImpl deviceManufacturerImpl = (DeviceManufacturerImpl)hashMap.get(string);
            if (deviceManufacturerImpl == null) {
                deviceManufacturerImpl = new DeviceManufacturerImpl(string);
                hashMap.put(string, deviceManufacturerImpl);
            }
            deviceManufacturerImpl.addTemplate(deviceTemplate);
        }
        return hashMap.values().toArray(new DeviceManager.DeviceManufacturer[hashMap.size()]);
    }

    public Device addVirtualDevice(int n, String string, String string2, String string3) throws DeviceManagerException {
        return this.createDevice(n, string, string2, string3);
    }

    protected Device createDevice(int n, String string, String string2, String string3) throws DeviceManagerException {
        if (n == 3) {
            DeviceImpl deviceImpl = new DeviceMediaRendererManual(this, string, string2, true, string3);
            deviceImpl = this.addDevice(deviceImpl);
            return deviceImpl;
        }
        throw new DeviceManagerException("Can't manually create this device type");
    }

    public void search(final int n, final DeviceSearchListener deviceSearchListener) {
        new AEThread2("DM:search", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DeviceManagerImpl deviceManagerImpl;
                Object object = DeviceManagerImpl.this;
                synchronized (object) {
                    DeviceManagerImpl.this.explicit_search++;
                }
                DeviceManagerImpl.this.tivo_manager.search();
                DeviceManagerImpl.this.drive_manager.search();
                object = new AESemaphore("DM:search");
                DeviceManagerListener deviceManagerListener = new DeviceManagerListener(){

                    public void deviceAdded(Device device) {
                        deviceSearchListener.deviceFound(device);
                    }

                    public void deviceChanged(Device device) {
                    }

                    public void deviceAttentionRequest(Device device) {
                    }

                    public void deviceRemoved(Device device) {
                    }

                    public void deviceManagerLoaded() {
                    }
                };
                try {
                    DeviceManagerImpl.this.addListener(deviceManagerListener);
                    DeviceManagerImpl.this.upnp_manager.search();
                    ((AESemaphore)object).reserve(n);
                    Object var4_4 = null;
                    deviceManagerImpl = DeviceManagerImpl.this;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    DeviceManagerImpl deviceManagerImpl2 = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl2) {
                        DeviceManagerImpl.this.explicit_search--;
                    }
                    DeviceManagerImpl.this.removeListener(deviceManagerListener);
                    deviceSearchListener.complete();
                    throw throwable;
                }
                synchronized (deviceManagerImpl) {
                    DeviceManagerImpl.this.explicit_search--;
                }
                DeviceManagerImpl.this.removeListener(deviceManagerListener);
                deviceSearchListener.complete();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl getDevice(String string) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_map.get(string);
        }
    }

    protected DeviceImpl addDevice(DeviceImpl deviceImpl) {
        return this.addDevice(deviceImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl addDevice(DeviceImpl deviceImpl, boolean bl) {
        DeviceImpl deviceImpl2 = null;
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceMediaRenderer deviceMediaRenderer;
            deviceImpl2 = this.device_map.get(deviceImpl.getID());
            if (deviceImpl2 != null) {
                deviceImpl2.updateFrom(deviceImpl, bl);
            } else if (deviceImpl.getType() == 3 && (deviceMediaRenderer = (DeviceMediaRenderer)((Object)deviceImpl)).getRendererSpecies() == 2 && !deviceMediaRenderer.isManual()) {
                for (DeviceImpl deviceImpl3 : this.device_list) {
                    DeviceMediaRenderer deviceMediaRenderer2;
                    if (deviceImpl3.getType() != 3 || (deviceMediaRenderer2 = (DeviceMediaRenderer)((Object)deviceImpl3)).getRendererSpecies() != 2 || !deviceMediaRenderer2.isManual()) continue;
                    deviceImpl2 = deviceImpl3;
                    this.log("Merging " + deviceImpl.getString() + " -> " + deviceImpl2.getString());
                    String string = deviceImpl.getID();
                    deviceImpl2.setSecondaryID(string);
                    deviceImpl2.updateFrom(deviceImpl, bl);
                }
            }
            if (deviceImpl2 == null) {
                this.device_list.add(deviceImpl);
                this.device_map.put(deviceImpl.getID(), deviceImpl);
            }
        }
        if (deviceImpl2 != null) {
            this.applyUpdates(deviceImpl2);
            return deviceImpl2;
        }
        deviceImpl.initialise();
        if (bl) {
            deviceImpl.alive();
        }
        this.applyUpdates(deviceImpl);
        this.deviceAdded(deviceImpl);
        this.configDirty();
        return deviceImpl;
    }

    protected void applyUpdates(DeviceImpl deviceImpl) {
        UPnPDevice uPnPDevice;
        DeviceMediaRenderer deviceMediaRenderer;
        if (deviceImpl.getType() == 3 && (deviceMediaRenderer = (DeviceMediaRenderer)((Object)deviceImpl)) instanceof DeviceUPnPImpl && (uPnPDevice = ((DeviceUPnPImpl)((Object)deviceMediaRenderer)).getUPnPDevice()) != null) {
            String string;
            String string2 = this.getOptionalLC(uPnPDevice.getManufacturer());
            String string3 = this.getOptionalLC(uPnPDevice.getModelName());
            String string4 = this.getOptionalLC(uPnPDevice.getFriendlyName());
            if (string2.startsWith("samsung")) {
                deviceImpl.setPersistentStringProperty("tt_rend_class", "samsung.generic");
                TranscodeProfile[] transcodeProfileArray = deviceImpl.getTranscodeProfiles();
                if (transcodeProfileArray.length == 0) {
                    deviceImpl.setTranscodeRequirement(1);
                } else {
                    deviceImpl.setTranscodeRequirement(2);
                }
            } else if (string2.startsWith("sony") && string4.startsWith("bravia")) {
                deviceImpl.setPersistentStringProperty("tt_rend_class", "sony.bravia");
                TranscodeProfile[] transcodeProfileArray = deviceImpl.getTranscodeProfiles();
            } else if (string3.equals("windows media player") && (string = uPnPDevice.getModelNumber()) != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 12) {
                        deviceImpl.setPersistentStringProperty("tt_rend_class", "ms_wmp.generic");
                        TranscodeProfile[] transcodeProfileArray = deviceImpl.getTranscodeProfiles();
                        if (transcodeProfileArray.length == 0) {
                            deviceImpl.setTranscodeRequirement(1);
                        } else {
                            deviceImpl.setTranscodeRequirement(2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private String getOptionalLC(String string) {
        if (string == null) {
            return "";
        }
        return string.toLowerCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(DeviceImpl deviceImpl) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceImpl deviceImpl2 = this.device_map.remove(deviceImpl.getID());
            if (deviceImpl2 == null) {
                return;
            }
            this.device_list.remove(deviceImpl);
            String string = deviceImpl.getSecondaryID();
            if (string != null) {
                this.device_map.remove(string);
            }
        }
        deviceImpl.destroy();
        this.deviceRemoved(deviceImpl);
        this.configDirty();
    }

    public boolean isBusy() {
        DeviceImpl[] deviceImplArray;
        if (this.getTranscodeManager().getQueue().isTranscoding()) {
            return true;
        }
        for (DeviceImpl deviceImpl : deviceImplArray = this.getDevices()) {
            if (!deviceImpl.isBusy()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceImpl[] getDevices() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_list.toArray(new DeviceImpl[this.device_list.size()]);
        }
    }

    public boolean getAutoSearch() {
        return this.auto_search;
    }

    public void setAutoSearch(boolean bl) {
        COConfigurationManager.setParameter(AUTO_SEARCH_CONFIG_KEY, bl);
    }

    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(RSS_ENABLE_CONFIG_KEY, false);
    }

    public void setRSSPublishEnabled(boolean bl) {
        COConfigurationManager.setParameter(RSS_ENABLE_CONFIG_KEY, bl);
    }

    public String getRSSLink() {
        return "http://frostwire.wordpress.com";
    }

    public DeviceOfflineDownloaderManager getOfflineDownlaoderManager() {
        return this;
    }

    public boolean isOfflineDownloadingEnabled() {
        return this.od_enabled;
    }

    public void setOfflineDownloadingEnabled(boolean bl) {
        COConfigurationManager.setParameter(OD_ENABLED_CONFIG_KEY, bl);
    }

    public boolean getOfflineDownloadingIsAuto() {
        return this.od_is_auto;
    }

    public void setOfflineDownloadingIsAuto(boolean bl) {
        COConfigurationManager.setParameter(OD_IS_AUTO_CONFIG_KEY, bl);
    }

    public boolean getOfflineDownloadingIncludePrivate() {
        return this.od_include_private;
    }

    public void setOfflineDownloadingIncludePrivate(boolean bl) {
        COConfigurationManager.setParameter(OD_INCLUDE_PRIVATE_CONFIG_KEY, bl);
    }

    public boolean isManualDownload(Download download) {
        return download.getBooleanAttribute(this.od_manual_ta);
    }

    public void addManualDownloads(Download[] downloadArray) {
        for (Download download : downloadArray) {
            download.setBooleanAttribute(this.od_manual_ta, true);
        }
        this.manageOD();
    }

    public void removeManualDownloads(Download[] downloadArray) {
        for (Download download : downloadArray) {
            download.setBooleanAttribute(this.od_manual_ta, false);
        }
        this.manageOD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExplicitSearch() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.explicit_search > 0;
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List list = (List)map.get("devices");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    try {
                        DeviceImpl deviceImpl = DeviceImpl.importFromBEncodedMapStatic(this, map2);
                        this.device_list.add(deviceImpl);
                        this.device_map.put(deviceImpl.getID(), deviceImpl);
                        String string = deviceImpl.getSecondaryID();
                        if (string != null) {
                            this.device_map.put(string, deviceImpl);
                        }
                        deviceImpl.initialise();
                        this.log("    loaded " + deviceImpl.getString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to import subscription from " + map2, throwable);
                    }
                }
            }
        }
    }

    protected void configDirty(DeviceImpl deviceImpl, boolean bl) {
        this.deviceChanged(deviceImpl, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (!DeviceManagerImpl.this.config_dirty) {
                            return;
                        }
                        DeviceManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.closing) {
                return;
            }
            this.config_dirty = false;
            this.config_unclean = false;
            if (this.device_list.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap hashMap = new HashMap();
                ArrayList arrayList = new ArrayList();
                hashMap.put("devices", arrayList);
                for (DeviceImpl deviceImpl : this.device_list) {
                    try {
                        HashMap hashMap2 = new HashMap();
                        deviceImpl.exportToBEncodedMap(hashMap2);
                        arrayList.add(hashMap2);
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to save device " + deviceImpl.getString(), throwable);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
            }
        }
    }

    protected void deviceAdded(DeviceImpl deviceImpl) {
        this.configDirty();
        try {
            PlatformDevicesMessenger.qosFoundDevice(deviceImpl);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        this.listeners.dispatch(1, deviceImpl);
    }

    protected void deviceChanged(DeviceImpl deviceImpl, boolean bl) {
        if (bl) {
            this.configDirty();
        } else {
            this.config_unclean = true;
        }
        this.listeners.dispatch(2, deviceImpl);
    }

    protected void deviceRemoved(DeviceImpl deviceImpl) {
        this.configDirty();
        this.listeners.dispatch(4, deviceImpl);
    }

    protected void requestAttention(DeviceImpl deviceImpl) {
        this.listeners.dispatch(3, deviceImpl);
    }

    protected URL getStreamURL(TranscodeFileImpl transcodeFileImpl, String string) {
        IPCInterface iPCInterface = this.upnp_manager.getUPnPAVIPC();
        if (iPCInterface != null) {
            try {
                DiskManagerFileInfo diskManagerFileInfo = transcodeFileImpl.getTargetFile();
                String string2 = (String)iPCInterface.invoke("getContentURL", new Object[]{diskManagerFileInfo});
                if (string2 != null && string2.length() > 0) {
                    if (string != null) {
                        string2 = string2.replace("127.0.0.1", string);
                    }
                    return new URL(string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getMimeType(TranscodeFileImpl transcodeFileImpl) {
        if (this.getMimeType_fails > 5) {
            return null;
        }
        IPCInterface iPCInterface = this.upnp_manager.getUPnPAVIPC();
        if (iPCInterface != null) {
            try {
                DiskManagerFileInfo diskManagerFileInfo = transcodeFileImpl.getTargetFile();
                String string = (String)iPCInterface.invoke("getMimeType", new Object[]{diskManagerFileInfo});
                if (string != null && string.length() > 0) {
                    return string;
                }
            }
            catch (Throwable throwable) {
                ++this.getMimeType_fails;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public File getDefaultWorkingDirectory() {
        return this.getDefaultWorkingDirectory(false);
    }

    public File getDefaultWorkingDirectory(boolean bl) {
        Object object;
        String string = COConfigurationManager.getStringParameter(CONFIG_DEFAULT_WORK_DIR, "").trim();
        if (string.length() == 0) {
            object = COConfigurationManager.getStringParameter("Default save path");
            string = (String)object + File.separator + TRANSCODE_DIR_DEFAULT;
        }
        if (!((File)(object = new File(string))).exists()) {
            String string2;
            if (((File)object).getName().equals(TRANSCODE_DIR_DEFAULT) && ((string2 = ((File)object).getParentFile().getName()).equals("Azureus Downloads") || string2.equals("Vuze Downloads"))) {
                String string3 = COConfigurationManager.getStringParameter("Default save path");
                object = new File(string3, TRANSCODE_DIR_DEFAULT);
            }
            if (bl) {
                ((File)object).mkdirs();
            }
        }
        return object;
    }

    public void setDefaultWorkingDirectory(File file) {
        File file2 = this.getDefaultWorkingDirectory(false);
        if (!file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            DeviceImpl[] deviceImplArray;
            for (DeviceImpl deviceImpl : deviceImplArray = this.getDevices()) {
                deviceImpl.resetWorkingDirectory();
            }
        }
        COConfigurationManager.setParameter(CONFIG_DEFAULT_WORK_DIR, file.getAbsolutePath());
    }

    public TranscodeManagerImpl getTranscodeManager() {
        if (this.transcode_manager == null) {
            this.ensureInitialised();
        }
        return this.transcode_manager;
    }

    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        return this.upnp_manager.getUnassociatedDevices();
    }

    public void addListener(DeviceManagerListener deviceManagerListener) {
        this.listeners.addListener(deviceManagerListener);
        if (this.initialized) {
            this.listeners.dispatch(deviceManagerListener, 5, null);
        }
    }

    public void removeListener(DeviceManagerListener deviceManagerListener) {
        this.listeners.removeListener(deviceManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AEDiagnosticsLogger getLogger() {
        Object object = this.logger_lock;
        synchronized (object) {
            if (this.logger == null) {
                this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
            }
            return this.logger;
        }
    }

    public void log(String string, Throwable throwable) {
        AEDiagnosticsLogger aEDiagnosticsLogger = this.getLogger();
        aEDiagnosticsLogger.log(string);
        aEDiagnosticsLogger.log(throwable);
    }

    public void log(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = this.getLogger();
        aEDiagnosticsLogger.log(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println(LOGGER_NAME);
        try {
            DeviceImpl[] deviceImplArray;
            indentWriter.indent();
            for (DeviceImpl deviceImpl : deviceImplArray = this.getDevices()) {
                deviceImpl.generate(indentWriter);
            }
            if (this.transcode_manager != null) {
                this.transcode_manager.generate(indentWriter);
            }
            Object var8_7 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    protected static class DeviceManufacturerImpl
    implements DeviceManager.DeviceManufacturer {
        private String name;
        private List<DeviceTemplate> templates = new ArrayList<DeviceTemplate>();

        protected DeviceManufacturerImpl(String string) {
            this.name = string;
        }

        protected void addTemplate(DeviceTemplate deviceTemplate) {
            this.templates.add(deviceTemplate);
        }

        public String getName() {
            return this.name;
        }

        public DeviceTemplate[] getDeviceTemplates() {
            return this.templates.toArray(new DeviceTemplate[this.templates.size()]);
        }
    }
}

