/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.custom.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationException;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.impl.CustomizationImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class CustomizationManagerImpl
implements CustomizationManager {
    private static CustomizationManagerImpl singleton = new CustomizationManagerImpl();
    private Map customization_file_map = new HashMap();
    private String current_customization_name;
    private CustomizationImpl current_customization;

    public static CustomizationManager getSingleton() {
        return singleton;
    }

    protected CustomizationManagerImpl() {
        String string;
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] vuzeFileArray, int n) {
                for (int i = 0; i < vuzeFileArray.length; ++i) {
                    VuzeFile vuzeFile = vuzeFileArray[i];
                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                        if (vuzeFileComponent.getType() != 64) continue;
                        try {
                            Map map = vuzeFileComponent.getContent();
                            ((CustomizationManagerImpl)CustomizationManagerImpl.getSingleton()).importCustomization(map);
                            vuzeFileComponent.setProcessed();
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        });
        File file = FileUtil.getUserFile("custom");
        File file2 = FileUtil.getApplicationFile("custom");
        this.loadCustomizations(file2);
        if (!file.equals(file2)) {
            this.loadCustomizations(file);
        }
        if (this.customization_file_map.get(string = COConfigurationManager.getStringParameter("customization.active.name", "")) == null) {
            for (String string2 : this.customization_file_map.keySet()) {
                String string3 = "customization.name." + string2 + ".version";
                String string4 = COConfigurationManager.getStringParameter(string3, "0");
                if (!string4.equals("0")) continue;
                string = string2;
                String string5 = ((String[])this.customization_file_map.get(string2))[0];
                COConfigurationManager.setParameter("customization.active.name", string);
                COConfigurationManager.setParameter(string3, string5);
                break;
            }
        }
        this.current_customization_name = string;
    }

    protected void loadCustomizations(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string = file2.getName();
                if (!string.endsWith(".zip")) {
                    this.logInvalid(file2);
                    continue;
                }
                String string2 = string.substring(0, string.length() - 4);
                int n = string2.lastIndexOf(95);
                if (n == -1) {
                    this.logInvalid(file2);
                    continue;
                }
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3.length() == 0 || !Constants.isValidVersionFormat(string4)) {
                    this.logInvalid(file2);
                    continue;
                }
                String[] stringArray = (String[])this.customization_file_map.get(string3);
                if (stringArray == null) {
                    this.customization_file_map.put(string3, new String[]{string4, file2.getAbsolutePath()});
                    continue;
                }
                String string5 = stringArray[0];
                if (Constants.compareVersions(string5, string4) >= 0) continue;
                this.customization_file_map.put(string3, new String[]{string4, file2.getAbsolutePath()});
            }
        }
    }

    protected void logInvalid(File file) {
        Debug.out("Invalid customization file name '" + file.getAbsolutePath() + "' - format must be <name>_<version>.zip where version is numeric and dot separated");
    }

    protected void importCustomization(Map map) throws CustomizationException {
        try {
            File file;
            String string = new String((byte[])map.get("name"), "UTF-8");
            String string2 = new String((byte[])map.get("version"), "UTF-8");
            if (!Constants.isValidVersionFormat(string2)) {
                throw new CustomizationException("Invalid version specification: " + string2);
            }
            byte[] byArray = (byte[])map.get("data");
            File file2 = FileUtil.getUserFile("custom");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (!(file = new File(file2, string + "_" + string2 + ".zip")).exists() && !FileUtil.writeBytesAsFile2(file.getAbsolutePath(), byArray)) {
                throw new CustomizationException("Failed to save customization to " + file);
            }
        }
        catch (CustomizationException customizationException) {
            throw customizationException;
        }
        catch (Throwable throwable) {
            throw new CustomizationException("Failed to import customization", throwable);
        }
    }

    protected void exportCustomization(CustomizationImpl customizationImpl, File file) throws CustomizationException {
        if (file.isDirectory()) {
            file = new File(file, customizationImpl.getName() + "_" + customizationImpl.getVersion() + ".vuze");
        }
        if (!file.getName().endsWith(".vuze")) {
            file = new File(file.getParentFile(), file.getName() + ".vuze");
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            byte[] byArray = FileUtil.readFileAsByteArray(customizationImpl.getContents());
            hashMap.put("name", customizationImpl.getName());
            hashMap.put("version", customizationImpl.getVersion());
            hashMap.put("data", byArray);
            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
            vuzeFile.addComponent(64, hashMap);
            vuzeFile.write(file);
        }
        catch (Throwable throwable) {
            throw new CustomizationException("Failed to export customization", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customization getActiveCustomization() {
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            String[] stringArray;
            if (this.current_customization == null && this.current_customization_name != null && (stringArray = (String[])this.customization_file_map.get(this.current_customization_name)) != null) {
                try {
                    this.current_customization = new CustomizationImpl(this, this.current_customization_name, stringArray[0], new File(stringArray[1]));
                    SimpleTimer.addEvent("Custom:clear", SystemTime.getCurrentTime() + 120000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent timerEvent2) {
                            CustomizationManagerImpl customizationManagerImpl = CustomizationManagerImpl.this;
                            synchronized (customizationManagerImpl) {
                                CustomizationManagerImpl.this.current_customization = null;
                            }
                        }
                    });
                }
                catch (CustomizationException customizationException) {
                    customizationException.printStackTrace();
                }
            }
            return this.current_customization;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customization[] getCustomizations() {
        ArrayList<CustomizationImpl> arrayList = new ArrayList<CustomizationImpl>();
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            for (Map.Entry entry : this.customization_file_map.entrySet()) {
                String string = (String)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                String string2 = stringArray[0];
                File file = new File(stringArray[1]);
                try {
                    CustomizationImpl customizationImpl = new CustomizationImpl(this, string, string2, file);
                    arrayList.add(customizationImpl);
                }
                catch (Throwable throwable) {}
            }
        }
        return arrayList.toArray(new Customization[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        try {
            CustomizationManagerImpl customizationManagerImpl = (CustomizationManagerImpl)CustomizationManagerImpl.getSingleton();
            CustomizationImpl customizationImpl = new CustomizationImpl(customizationManagerImpl, "blah", "1.2", new File("C:\\temp\\cust\\details.zip"));
            customizationImpl.exportToVuzeFile(new File("C:\\temp\\cust"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

