/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.secure.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.RSAUtil;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class SecureMessageServiceClientHelper
implements ClientMessageService {
    private ClientMessageService delegate;
    private SecretKey session_key;
    private byte[] encryped_session_key;

    public static ClientMessageService getServerService(String string, int n, int n2, String string2, RSAPublicKey rSAPublicKey) throws IOException {
        return new SecureMessageServiceClientHelper(string, n, n2, string2, rSAPublicKey);
    }

    protected SecureMessageServiceClientHelper(String string, int n, int n2, String string2, RSAPublicKey rSAPublicKey) throws IOException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DESede");
            this.session_key = keyGenerator.generateKey();
            byte[] byArray = this.session_key.getEncoded();
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, rSAPublicKey);
                this.encryped_session_key = cipher.doFinal(byArray);
            }
            catch (Throwable throwable) {
                RSAEngine rSAEngine = new RSAEngine();
                PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(rSAEngine);
                CipherParameters cipherParameters = RSAUtil.generatePublicKeyParameter(rSAPublicKey);
                cipherParameters = new ParametersWithRandom(cipherParameters, RandomUtils.SECURE_RANDOM);
                pKCS1Encoding.init(true, cipherParameters);
                this.encryped_session_key = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Secure client message service initialisation fails - " + Debug.getNestedExceptionMessage(throwable));
        }
        this.delegate = ClientMessageServiceClient.getServerService(string, n, string2);
    }

    public void sendMessage(Map map) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            byte[] byArray = StaticUtilities.getFormatters().bEncode(map);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(1, this.session_key);
            byte[] byArray2 = cipher.doFinal(byArray);
            hashMap.put("ver", "1");
            hashMap.put("alg", "DESede");
            hashMap.put("key", this.encryped_session_key);
            hashMap.put("content", byArray2);
        }
        catch (Throwable throwable) {
            throw new IOException("send message failed - " + Debug.getNestedExceptionMessage(throwable));
        }
        this.delegate.sendMessage(hashMap);
    }

    public Map receiveMessage() throws IOException {
        Map map = this.delegate.receiveMessage();
        byte[] byArray = (byte[])map.get("content");
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(2, this.session_key);
            byte[] byArray2 = cipher.doFinal(byArray);
            Map map2 = StaticUtilities.getFormatters().bDecode(byArray2);
            return map2;
        }
        catch (Throwable throwable) {
            throw new IOException("send message failed - " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    public void close() {
        this.delegate.close();
    }

    public void setMaximumMessageSize(int n) {
        this.delegate.setMaximumMessageSize(n);
    }
}

