/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import com.google.inject.Provider;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.ProtocolBandwidthTracker;
import org.limewire.nio.channel.BufferReader;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.ssl.SSLReadWriteChannel;
import org.limewire.nio.ssl.TLSNIOSocket;
import org.limewire.util.BufferUtils;

public class SSLUtils {
    private static final Executor TLS_PROCESSOR = ExecutorsHelper.newProcessingQueue((String)"TLSProcessor");
    private static final Provider<SSLContext> TLS_CONTEXT = new AbstractLazySingletonProvider<SSLContext>(){

        protected SSLContext createObject() {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                return sSLContext;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                throw new IllegalStateException(keyManagementException);
            }
        }
    };

    private SSLUtils() {
    }

    public static String[] getTLSCipherSuites() {
        return new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    }

    public static Executor getExecutor() {
        return TLS_PROCESSOR;
    }

    public static SSLContext getTLSContext() {
        return (SSLContext)TLS_CONTEXT.get();
    }

    public static boolean isTLSEnabled(Socket socket) {
        return socket instanceof TLSNIOSocket;
    }

    public static boolean isStartTLSCapable(Socket socket) {
        return socket instanceof AbstractNBSocket;
    }

    public static TLSNIOSocket startTLS(Socket socket, ByteBuffer byteBuffer) throws IOException {
        if (socket instanceof AbstractNBSocket) {
            TLSNIOSocket tLSNIOSocket = new TLSNIOSocket(socket);
            if (byteBuffer.hasRemaining()) {
                SSLReadWriteChannel sSLReadWriteChannel = tLSNIOSocket.getSSLChannel();
                InterestReadableByteChannel interestReadableByteChannel = sSLReadWriteChannel.getReadChannel();
                sSLReadWriteChannel.setReadChannel(new BufferReader(byteBuffer));
                sSLReadWriteChannel.read(BufferUtils.getEmptyBuffer());
                if (byteBuffer.hasRemaining()) {
                    throw new IllegalStateException("unable to read all prebuffered data in one pass!");
                }
                sSLReadWriteChannel.setReadChannel(interestReadableByteChannel);
            }
            return tLSNIOSocket;
        }
        throw new IllegalArgumentException("cannot wrap non AbstractNBSocket");
    }

    public static ProtocolBandwidthTracker getSSLBandwidthTracker(Socket socket) {
        if (socket instanceof TLSNIOSocket) {
            return new SSLChannelTracker(((TLSNIOSocket)socket).getSSLChannel());
        }
        return EmptyTracker.instance();
    }

    private static class SSLChannelTracker
    implements ProtocolBandwidthTracker {
        private final SSLReadWriteChannel channel;

        SSLChannelTracker(SSLReadWriteChannel sSLReadWriteChannel) {
            this.channel = sSLReadWriteChannel;
        }

        public long getReadBytesConsumed() {
            return this.channel.getReadBytesConsumed();
        }

        public long getReadBytesProduced() {
            return this.channel.getReadBytesProduced();
        }

        public long getWrittenBytesConsumed() {
            return this.channel.getWrittenBytesConsumed();
        }

        public long getWrittenBytesProduced() {
            return this.channel.getWrittenBytesProduced();
        }
    }

    public static class EmptyTracker
    implements ProtocolBandwidthTracker {
        private static final EmptyTracker instance = new EmptyTracker();

        public static final EmptyTracker instance() {
            return instance;
        }

        private EmptyTracker() {
        }

        public long getReadBytesConsumed() {
            return 0L;
        }

        public long getReadBytesProduced() {
            return 0L;
        }

        public long getWrittenBytesConsumed() {
            return 0L;
        }

        public long getWrittenBytesProduced() {
            return 0L;
        }
    }
}

