/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.util.BufferUtils;
import org.limewire.util.FileUtils;

class SSLReadWriteChannel
implements InterestReadableByteChannel,
InterestWritableByteChannel,
ChannelReader,
ChannelWriter {
    private static final Log LOG = LogFactory.getLog(SSLReadWriteChannel.class);
    private final SSLContext context;
    private final Executor sslBlockingExecutor;
    private SSLEngine engine;
    private ByteBuffer readIncoming;
    private ByteBuffer readOutgoing;
    private ByteBuffer writeOutgoing;
    private volatile InterestReadableByteChannel readSink;
    private volatile InterestWritableByteChannel writeSink;
    private volatile WriteObserver writeWanter;
    private volatile boolean needsHandshakeWrap = false;
    private volatile boolean needsHandshakeUnwrap = false;
    private volatile boolean readDataLeft = false;
    private final AtomicBoolean firstReadDone = new AtomicBoolean(false);
    private volatile long readConsumed;
    private volatile long readProduced;
    private volatile long writeConsumed;
    private volatile long writeProduced;
    private volatile boolean shutdown = false;
    private final Object initLock = new Object();
    private final Object taskLock = new Object();
    private volatile boolean taskScheduled = false;
    private boolean readInterest = false;
    private final Object readInterestLock = new Object();
    private final ByteBufferCache byteBufferCache;
    private final Executor networkExecutor;

    public SSLReadWriteChannel(SSLContext sSLContext, Executor executor, ByteBufferCache byteBufferCache, Executor executor2) {
        this.sslBlockingExecutor = executor;
        this.context = sSLContext;
        this.byteBufferCache = byteBufferCache;
        this.networkExecutor = executor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(SocketAddress socketAddress, String[] stringArray, boolean bl, boolean bl2) {
        Object object = this.initLock;
        synchronized (object) {
            Object object2;
            if (this.shutdown) {
                LOG.debug((Object)"Not initializing because already shutdown.");
                return;
            }
            if (socketAddress != null) {
                if (!(socketAddress instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("unsupported SocketAddress");
                }
                object2 = (InetSocketAddress)socketAddress;
                String string = ((InetSocketAddress)object2).getAddress().getHostAddress();
                int n = ((InetSocketAddress)object2).getPort();
                this.engine = this.context.createSSLEngine(string, n);
            } else {
                this.engine = this.context.createSSLEngine();
            }
            this.engine.setEnabledCipherSuites(stringArray);
            this.engine.setUseClientMode(bl);
            if (!bl) {
                this.engine.setWantClientAuth(bl2);
                this.engine.setNeedClientAuth(bl2);
            }
            object2 = this.engine.getSession();
            this.readIncoming = this.byteBufferCache.getHeap(object2.getPacketBufferSize());
            this.writeOutgoing = this.byteBufferCache.getHeap(object2.getPacketBufferSize());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Initialized engine: " + this.engine + ", session: " + object2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        SSLEngineResult sSLEngineResult;
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        if (this.taskScheduled) {
            return 0;
        }
        int n = 0;
        if (this.readOutgoing != null && this.readOutgoing.position() > 0) {
            n += BufferUtils.transfer((ByteBuffer)this.readOutgoing, (ByteBuffer)byteBuffer);
            if (this.readOutgoing.hasRemaining()) {
                LOG.debug((Object)"Transferred less than we have left!");
                return n;
            }
        }
        do {
            if (this.firstReadDone.get() && !byteBuffer.hasRemaining() && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                LOG.debug((Object)"No room left to transfer data, exiting");
                return n;
            }
            int n2 = -1;
            while (this.readIncoming.hasRemaining() && (n2 = this.readSink.read(this.readIncoming)) > 0) {
            }
            if (n2 == -1 && this.readIncoming.position() == 0) {
                LOG.debug((Object)"Read EOF, no data to transfer.  Connection finished");
                return -1;
            }
            if (this.readIncoming.position() == 0) {
                LOG.debug((Object)"Unable to read anything, exiting read loop");
                return 0;
            }
            this.readIncoming.flip();
            sSLEngineResult = this.engine.unwrap(this.readIncoming, byteBuffer);
            this.readProduced += (long)sSLEngineResult.bytesProduced();
            this.readConsumed += (long)sSLEngineResult.bytesConsumed();
            n += sSLEngineResult.bytesProduced();
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                Object object;
                if (this.readOutgoing == null) {
                    object = this.initLock;
                    synchronized (object) {
                        if (this.shutdown) {
                            throw new IOException("Shutdown while sizing");
                        }
                        this.readOutgoing = this.byteBufferCache.getHeap(this.engine.getSession().getApplicationBufferSize());
                    }
                }
                sSLEngineResult = this.engine.unwrap(this.readIncoming, this.readOutgoing);
                this.readProduced += (long)sSLEngineResult.bytesProduced();
                this.readConsumed += (long)sSLEngineResult.bytesConsumed();
                status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (this.readIncoming.position() == 0 && this.readIncoming.capacity() == 16665 && this.engine.getSession().getPacketBufferSize() == 33049) {
                        object = this.initLock;
                        synchronized (object) {
                            if (this.shutdown) {
                                throw new IOException("Shutdown while resizing.");
                            }
                            ByteBuffer byteBuffer2 = this.byteBufferCache.getHeap(this.engine.getSession().getPacketBufferSize());
                            BufferUtils.transfer((ByteBuffer)this.readIncoming, (ByteBuffer)byteBuffer2, (boolean)false);
                            byteBuffer2.flip();
                            assert (byteBuffer2.limit() == this.readIncoming.position());
                            assert (byteBuffer2.position() == 0);
                            this.byteBufferCache.release(this.readIncoming);
                            this.readIncoming = byteBuffer2;
                            assert (this.readOutgoing.position() == 0);
                            this.byteBufferCache.release(this.readOutgoing);
                            this.readOutgoing = this.byteBufferCache.getHeap(this.engine.getSession().getApplicationBufferSize());
                            sSLEngineResult = this.engine.unwrap(this.readIncoming, this.readOutgoing);
                            this.readProduced += (long)sSLEngineResult.bytesProduced();
                            this.readConsumed += (long)sSLEngineResult.bytesConsumed();
                            status = sSLEngineResult.getStatus();
                            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                throw new IllegalStateException("tried resizing, but still not enough room in fallback TLS buffer!  readOutgoing: " + this.readOutgoing + ", readIncoming: " + this.readIncoming + ", packet size: " + this.engine.getSession().getPacketBufferSize() + ", appl size: " + this.engine.getSession().getApplicationBufferSize());
                            }
                        }
                    } else {
                        throw new IllegalStateException("cannot resize, and not enough room in fallback TLS buffer!  readOutgoing: " + this.readOutgoing + ", readIncoming: " + this.readIncoming + ", packet size: " + this.engine.getSession().getPacketBufferSize() + ", appl size: " + this.engine.getSession().getApplicationBufferSize());
                    }
                }
                n += BufferUtils.transfer((ByteBuffer)this.readOutgoing, (ByteBuffer)byteBuffer);
            }
            this.firstReadDone.set(true);
            if (this.readIncoming.hasRemaining()) {
                this.readDataLeft = true;
                this.readIncoming.compact();
            } else {
                this.readDataLeft = false;
                this.readIncoming.clear();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Read unwrap result: " + sSLEngineResult + ", transferred: " + n));
            }
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (n == 0 && n2 == -1) {
                    LOG.debug((Object)"Read EOF & underflow when unwrapping.  Connection finished");
                    return -1;
                }
                return n;
            }
            if (status != SSLEngineResult.Status.CLOSED) continue;
            if (n == 0) {
                return -1;
            }
            return n;
        } while (this.processHandshakeResult(true, false, sSLEngineResult.getHandshakeStatus()));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processHandshakeResult(boolean bl, boolean bl2, SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing result from: " + this.engine + ", result: " + (Object)((Object)handshakeStatus)));
        }
        this.needsHandshakeWrap = false;
        this.needsHandshakeUnwrap = false;
        switch (handshakeStatus) {
            case NEED_TASK: {
                this.needTask();
                return false;
            }
            case NEED_WRAP: {
                this.needsHandshakeWrap = true;
                this.readSink.interestRead(false);
                this.writeSink.interestWrite(this, true);
                return bl2;
            }
            case NEED_UNWRAP: {
                this.writeSink.interestWrite(null, false);
                Object object = this.readInterestLock;
                synchronized (object) {
                    this.needsHandshakeUnwrap = true;
                    this.readSink.interestRead(true);
                }
                if (this.readDataLeft && !bl) {
                    this.networkExecutor.execute(new Runnable(){

                        public void run() {
                            try {
                                SSLReadWriteChannel.this.read(BufferUtils.getEmptyBuffer());
                            }
                            catch (IOException iOException) {
                                FileUtils.close((Closeable)SSLReadWriteChannel.this);
                            }
                        }
                    });
                }
                return bl;
            }
            case FINISHED: {
                Object object = this.readInterestLock;
                synchronized (object) {
                    this.readSink.interestRead(this.readInterest);
                }
                this.writeSink.interestWrite(this, true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void needTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this.taskScheduled = true;
            this.readSink.interestRead(false);
            this.writeSink.interestWrite(null, false);
        }
        while (true) {
            if ((object = this.engine.getDelegatedTask()) == null) break;
            this.sslBlockingExecutor.execute((Runnable)object);
        }
        this.sslBlockingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = SSLReadWriteChannel.this.taskLock;
                synchronized (object) {
                    SSLReadWriteChannel.this.taskScheduled = false;
                }
                object = SSLReadWriteChannel.this.engine.getHandshakeStatus();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Task(s) finished, status: " + object));
                }
                SSLReadWriteChannel.this.processHandshakeResult(false, false, (SSLEngineResult.HandshakeStatus)((Object)object));
            }
        });
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        if (this.taskScheduled) {
            return 0;
        }
        int n = 0;
        do {
            boolean bl = this.writeOutgoing.position() == 0;
            SSLEngineResult sSLEngineResult = this.engine.wrap(byteBuffer, this.writeOutgoing);
            this.writeProduced += (long)sSLEngineResult.bytesProduced();
            this.writeConsumed += (long)sSLEngineResult.bytesConsumed();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Wrap result: " + sSLEngineResult));
            }
            n += sSLEngineResult.bytesConsumed();
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.CLOSED && !this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.processHandshakeResult(false, true, sSLEngineResult.getHandshakeStatus())) break;
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            if (!bl) break;
            throw new IllegalStateException("outgoing TLS buffer not large enough!");
        } while (byteBuffer.hasRemaining());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        InterestWritableByteChannel interestWritableByteChannel = this.writeSink;
        if (interestWritableByteChannel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        while (true) {
            WriteObserver writeObserver;
            if (this.writeOutgoing.position() > 0) {
                this.writeOutgoing.flip();
                this.writeSink.write(this.writeOutgoing);
                if (this.writeOutgoing.hasRemaining()) {
                    this.writeOutgoing.compact();
                    return true;
                }
                this.writeOutgoing.clear();
            }
            if (this.needsHandshakeWrap) {
                LOG.debug((Object)"Forcing a handshake wrap");
                this.write(BufferUtils.getEmptyBuffer());
                if (this.writeOutgoing.position() > 0) continue;
            }
            if ((writeObserver = this.writeWanter) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Telling interested parties to write.  (a " + writeObserver + ")"));
                }
                writeObserver.handleWrite();
            }
            if (this.writeOutgoing.position() == 0) break;
        }
        SSLReadWriteChannel sSLReadWriteChannel = this;
        synchronized (sSLReadWriteChannel) {
            if (this.writeWanter == null) {
                interestWritableByteChannel.interestWrite(this, false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.initLock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (!this.isOpen()) {
                LOG.debug((Object)"Shutting down SSL channel");
                this.shutdown = true;
            }
        }
        if (this.shutdown) {
            this.networkExecutor.execute(new Runnable(){

                public void run() {
                    if (SSLReadWriteChannel.this.readIncoming != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.readIncoming);
                    }
                    if (SSLReadWriteChannel.this.readOutgoing != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.readOutgoing);
                    }
                    if (SSLReadWriteChannel.this.writeOutgoing != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.writeOutgoing);
                    }
                }
            });
        }
        if ((object = this.writeWanter) != null) {
            object.shutdown();
        }
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.readSink;
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.readSink = interestReadableByteChannel;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.writeSink;
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.writeSink = interestWritableByteChannel;
    }

    public void close() throws IOException {
        this.readSink.close();
        this.writeSink.close();
    }

    public boolean isOpen() {
        return this.readSink != null && this.readSink.isOpen() && this.writeSink != null && this.writeSink.isOpen();
    }

    public void handleIOException(IOException iOException) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRead(boolean bl) {
        Object object = this.taskLock;
        synchronized (object) {
            Object object2 = this.readInterestLock;
            synchronized (object2) {
                this.readInterest = bl;
                boolean bl2 = !this.taskScheduled && (this.needsHandshakeUnwrap || bl);
                this.readSink.interestRead(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interestWrite(WriteObserver writeObserver, boolean bl) {
        this.writeWanter = bl ? writeObserver : null;
        InterestWritableByteChannel interestWritableByteChannel = this.writeSink;
        if (interestWritableByteChannel != null) {
            Object object = this.taskLock;
            synchronized (object) {
                interestWritableByteChannel.interestWrite(this, !this.taskScheduled);
            }
        }
    }

    long getReadBytesProduced() {
        return this.readProduced;
    }

    long getReadBytesConsumed() {
        return this.readConsumed;
    }

    long getWrittenBytesProduced() {
        return this.writeProduced;
    }

    long getWrittenBytesConsumed() {
        return this.writeConsumed;
    }

    SSLSession getSession() {
        return this.engine != null ? this.engine.getSession() : null;
    }

    boolean isHandshaking() {
        return !this.firstReadDone.get() || this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel interestWritableByteChannel = this.writeSink;
        return this.writeOutgoing.position() > 0 || interestWritableByteChannel != null && interestWritableByteChannel.hasBufferedOutput();
    }
}

