/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class DeflaterWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;
    private ByteBuffer outgoing;
    private ByteBuffer incoming;
    private Deflater deflater;
    private int sync = 0;
    private static final byte[] EMPTY = new byte[0];

    public DeflaterWriter(Deflater deflater) {
        this(deflater, null);
    }

    public DeflaterWriter(Deflater deflater, InterestWritableByteChannel interestWritableByteChannel) {
        this.deflater = deflater;
        this.incoming = ByteBuffer.allocate(4096);
        this.outgoing = ByteBuffer.allocate(512);
        this.outgoing.flip();
        this.channel = interestWritableByteChannel;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.channel = interestWritableByteChannel;
        interestWritableByteChannel.interestWrite(this, true);
    }

    public synchronized void interestWrite(WriteObserver writeObserver, boolean bl) {
        this.observer = bl ? writeObserver : null;
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.interestWrite(this, true);
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        if (this.incoming.hasRemaining()) {
            int n2;
            int n3 = this.incoming.remaining();
            if (n3 >= (n2 = byteBuffer.remaining())) {
                this.incoming.put(byteBuffer);
                n = n2;
            } else {
                int n4 = byteBuffer.limit();
                int n5 = byteBuffer.position();
                byteBuffer.limit(n5 + n3);
                this.incoming.put(byteBuffer);
                byteBuffer.limit(n4);
                n = n3;
            }
        }
        return n;
    }

    public void close() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return interestWritableByteChannel != null ? interestWritableByteChannel.isOpen() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        block9: while (true) {
            this.channel.write(this.outgoing);
            if (this.outgoing.hasRemaining()) {
                return true;
            }
            while (true) {
                int n;
                try {
                    n = this.deflater.deflate(this.outgoing.array());
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                if (n > 0) {
                    this.outgoing.position(0).limit(n);
                    continue block9;
                }
                try {
                    if (this.sync == 0) {
                        this.deflater.setInput(EMPTY);
                        this.deflater.setLevel(0);
                        this.sync = 1;
                        continue;
                    }
                    if (this.sync == 1) {
                        this.deflater.setLevel(-1);
                        this.sync = 2;
                        continue;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                if (this.incoming.position() == 0) {
                    WriteObserver writeObserver = this.observer;
                    if (writeObserver != null) {
                        writeObserver.handleWrite();
                    }
                    if (this.incoming.position() == 0) {
                        DeflaterWriter deflaterWriter = this;
                        synchronized (deflaterWriter) {
                            if (this.observer == null) {
                                interestWritableByteChannel.interestWrite(this, false);
                            }
                        }
                        return false;
                    }
                }
                try {
                    this.deflater.setInput(this.incoming.array(), 0, this.incoming.position());
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                this.incoming.clear();
                this.sync = 0;
            }
            break;
        }
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return this.incoming.position() > 0 || this.outgoing.hasRemaining() || interestWritableByteChannel != null && interestWritableByteChannel.hasBufferedOutput();
    }
}

