/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

class SocketInterestWriteAdapter
implements InterestWritableByteChannel {
    private volatile WriteObserver interested;
    private SocketChannel channel;
    private boolean shutdown = false;

    SocketInterestWriteAdapter(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.channel.write(byteBuffer);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public synchronized void interestWrite(WriteObserver writeObserver, boolean bl) {
        if (!this.shutdown) {
            this.interested = bl ? writeObserver : null;
            NIODispatcher.instance().interestWrite(this.channel, bl);
        }
    }

    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.interested;
        if (writeObserver != null) {
            return writeObserver.handleWrite();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WriteObserver writeObserver = this;
        synchronized (writeObserver) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        writeObserver = this.interested;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
        this.interested = null;
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported", iOException);
    }

    public boolean hasBufferedOutput() {
        return false;
    }
}

