/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.NIOInputStream;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.ReadTimeout;

class BufferInputStream
extends InputStream
implements Shutdownable {
    private final Object LOCK = new Object();
    private final Shutdownable shutdownHandler;
    private final ReadTimeout readTimeoutHandler;
    private final ByteBuffer buffer;
    private final NIOInputStream nioStream;
    private InterestReadableByteChannel channel;
    private boolean shutdown = false;
    private boolean finished = false;

    BufferInputStream(ByteBuffer byteBuffer, ReadTimeout readTimeout, Shutdownable shutdownable, InterestReadableByteChannel interestReadableByteChannel, NIOInputStream nIOInputStream) {
        this.readTimeoutHandler = readTimeout;
        this.shutdownHandler = shutdownable;
        this.buffer = byteBuffer;
        this.channel = interestReadableByteChannel;
        this.nioStream = nIOInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.channel = interestReadableByteChannel;
        }
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            this.buffer.compact();
            this.channel.interestRead(true);
            return by & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.channel.interestRead(true);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    private void waitImpl() throws IOException {
        long l = this.readTimeoutHandler.getReadTimeout();
        if (l == -1L) {
            throw new SocketException("unable to get read timeout");
        }
        boolean bl = false;
        while (this.buffer.position() == 0 && !this.finished) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            if (bl && l != 0L) {
                throw new SocketTimeoutException("read timed out (" + l + ")");
            }
            this.nioStream.readHappening();
            try {
                this.LOCK.wait(l);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException);
            }
            bl = true;
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() throws IOException {
        this.shutdownHandler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

