/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxySettings;
import org.limewire.net.SocketBindingSettings;
import org.limewire.net.SocketController;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;

@Singleton
class SimpleSocketController
implements SocketController {
    private InetSocketAddress lastBindAddr;
    private final ProxyManager proxyManager;
    private final SocketBindingSettings defaultSocketBindingSettings;

    @Inject
    SimpleSocketController(ProxyManager proxyManager, SocketBindingSettings socketBindingSettings) {
        this.proxyManager = proxyManager;
        this.defaultSocketBindingSettings = socketBindingSettings;
    }

    public Socket connect(NBSocketFactory nBSocketFactory, InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        return this.connect(null, null, nBSocketFactory, inetSocketAddress, n, connectObserver);
    }

    public Socket connect(NBSocket nBSocket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver) throws IOException {
        return this.connect(nBSocket, inetSocketAddress, null, inetSocketAddress2, n, connectObserver);
    }

    public Socket connect(NBSocket nBSocket, InetSocketAddress inetSocketAddress, NBSocketFactory nBSocketFactory, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver) throws IOException {
        ProxySettings.ProxyType proxyType = this.proxyManager.getProxyType(inetSocketAddress2.getAddress());
        if (proxyType != ProxySettings.ProxyType.NONE) {
            return this.connectProxy(nBSocket, inetSocketAddress, nBSocketFactory, proxyType, inetSocketAddress2, n, connectObserver);
        }
        return this.connectPlain(nBSocket, inetSocketAddress, nBSocketFactory, inetSocketAddress2, n, connectObserver);
    }

    public int getNumAllowedSockets() {
        return Integer.MAX_VALUE;
    }

    public boolean removeConnectObserver(ConnectObserver connectObserver) {
        return false;
    }

    public int getNumWaitingSockets() {
        return 0;
    }

    protected Socket connectPlain(NBSocket nBSocket, InetSocketAddress inetSocketAddress, NBSocketFactory nBSocketFactory, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver) throws IOException {
        if (nBSocket == null) {
            nBSocket = nBSocketFactory.createSocket();
        }
        this.bindSocket(nBSocket, inetSocketAddress);
        if (connectObserver == null) {
            nBSocket.connect((SocketAddress)inetSocketAddress2, n);
        } else {
            nBSocket.connect((SocketAddress)inetSocketAddress2, n, connectObserver);
        }
        return nBSocket;
    }

    protected void bindSocket(NBSocket nBSocket, InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress != null) {
            nBSocket.bind((SocketAddress)inetSocketAddress);
        } else if (this.defaultSocketBindingSettings.isSocketBindingRequired()) {
            String string = this.defaultSocketBindingSettings.getAddressToBindTo();
            if (this.lastBindAddr == null || !this.lastBindAddr.getAddress().getHostAddress().equals(string)) {
                this.lastBindAddr = new InetSocketAddress(string, 0);
            }
            try {
                nBSocket.bind((SocketAddress)this.lastBindAddr);
            }
            catch (IOException iOException) {
                this.defaultSocketBindingSettings.bindingFailed();
            }
        }
    }

    protected Socket connectProxy(NBSocket nBSocket, InetSocketAddress inetSocketAddress, NBSocketFactory nBSocketFactory, ProxySettings.ProxyType proxyType, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver) throws IOException {
        InetSocketAddress inetSocketAddress3 = this.proxyManager.getProxyHost();
        if (connectObserver != null) {
            return this.connectPlain(nBSocket, inetSocketAddress, nBSocketFactory, inetSocketAddress3, n, this.proxyManager.getConnectorFor(proxyType, connectObserver, inetSocketAddress2, n));
        }
        Socket socket = this.connectPlain(nBSocket, inetSocketAddress, nBSocketFactory, inetSocketAddress3, n, null);
        try {
            return this.proxyManager.establishProxy(proxyType, socket, inetSocketAddress2, n);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }
}

