/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.ibm.icu.text.Normalizer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.AbstractI18NConverter;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;

final class I18NConvertICU
extends AbstractI18NConverter {
    private BitSet _excluded;
    private BitSet _replaceWithSpace;
    private Map _cMap;

    I18NConvertICU() throws IOException, ClassNotFoundException {
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        HashMap hashMap = null;
        InputStream inputStream = CommonUtils.getResourceStream("org/limewire/util/excluded.dat");
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        bitSet = (BitSet)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = CommonUtils.getResourceStream("org/limewire/util/caseMap.dat");
        objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(inputStream));
        hashMap = (HashMap)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = CommonUtils.getResourceStream("org/limewire/util/replaceSpace.dat");
        objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        bitSet2 = (BitSet)objectInputStream.readObject();
        objectInputStream.close();
        this._excluded = bitSet;
        this._cMap = hashMap;
        this._replaceWithSpace = bitSet2;
    }

    public String getNorm(String string) {
        return this.convert(string);
    }

    public String compose(String string) {
        return Normalizer.compose((String)string, (boolean)false);
    }

    private String convert(String string) {
        String string2 = Normalizer.decompose((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this._replaceWithSpace.get(c)) {
                stringBuilder.append(" ");
                continue;
            }
            if (this._excluded.get(c)) continue;
            String string3 = (String)this._cMap.get(String.valueOf(c));
            if (string3 != null) {
                stringBuilder.append(string3);
                continue;
            }
            stringBuilder.append(c);
        }
        return this.blockSplit(Normalizer.compose((String)stringBuilder.toString(), (boolean)false));
    }
}

