/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class SwingSafePropertyChangeSupport
extends PropertyChangeSupport {
    public SwingSafePropertyChangeSupport(Object object) {
        super(object);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.unwrap(super.getPropertyChangeListeners());
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.unwrap(super.getPropertyChangeListeners(string));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (EventQueue.isDispatchThread()) {
            propertyChangeListener = this.wrap(propertyChangeListener);
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (EventQueue.isDispatchThread()) {
            propertyChangeListener = this.wrap(propertyChangeListener);
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeListener = this.wrap(propertyChangeListener, super.getPropertyChangeListeners());
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        propertyChangeListener = this.wrap(propertyChangeListener, super.getPropertyChangeListeners(string));
        super.removePropertyChangeListener(string, propertyChangeListener);
    }

    private PropertyChangeListener wrap(PropertyChangeListener propertyChangeListener, PropertyChangeListener[] propertyChangeListenerArray) {
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray) {
            if (propertyChangeListener2 == propertyChangeListener) {
                return propertyChangeListener2;
            }
            if (!(propertyChangeListener2 instanceof SwingSafePropertyChangeListener) || ((SwingSafePropertyChangeListener)propertyChangeListener2).delegate != propertyChangeListener) continue;
            return propertyChangeListener2;
        }
        return propertyChangeListener;
    }

    private PropertyChangeListener wrap(PropertyChangeListener propertyChangeListener) {
        return new SwingSafePropertyChangeListener(propertyChangeListener);
    }

    private PropertyChangeListener[] unwrap(PropertyChangeListener[] propertyChangeListenerArray) {
        PropertyChangeListener[] propertyChangeListenerArray2 = null;
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[i];
            if (!(propertyChangeListener instanceof SwingSafePropertyChangeListener)) continue;
            if (propertyChangeListenerArray2 == null) {
                propertyChangeListenerArray2 = new PropertyChangeListener[propertyChangeListenerArray.length];
                System.arraycopy(propertyChangeListenerArray, 0, propertyChangeListenerArray2, 0, propertyChangeListenerArray2.length);
            }
            propertyChangeListenerArray2[i] = ((SwingSafePropertyChangeListener)propertyChangeListener).delegate;
        }
        return propertyChangeListenerArray2 == null ? propertyChangeListenerArray : propertyChangeListenerArray2;
    }

    private static class SwingSafePropertyChangeListener
    implements PropertyChangeListener {
        private final PropertyChangeListener delegate;

        public SwingSafePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate = propertyChangeListener;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.delegate.propertyChange(propertyChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SwingSafePropertyChangeListener.this.delegate.propertyChange(propertyChangeEvent);
                    }
                });
            }
        }
    }
}

