/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.SourcedEvent;
import org.limewire.listener.SourcedEventMulticaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcedEventMulticasterImpl<E extends SourcedEvent<S>, S>
implements SourcedEventMulticaster<E, S> {
    private final EventListenerList<E> listenersForAll = new EventListenerList();
    private final Map<S, EventListenerList<E>> sourceListeners = new ConcurrentHashMap<S, EventListenerList<E>>();

    @Override
    public void handleEvent(E e) {
        this.broadcast(e);
    }

    @Override
    public void broadcast(E e) {
        this.listenersForAll.broadcast(e);
        EventListenerList<E> eventListenerList = this.sourceListeners.get(e.getSource());
        if (eventListenerList != null) {
            eventListenerList.broadcast(e);
        }
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        this.listenersForAll.addListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(S s, EventListener<E> eventListener) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            EventListenerList<E> eventListenerList = this.sourceListeners.get(s);
            if (eventListenerList == null) {
                eventListenerList = new EventListenerList();
                this.sourceListeners.put(s, eventListenerList);
            }
            eventListenerList.addListener(eventListener);
        }
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.listenersForAll.removeListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(S s, EventListener<E> eventListener) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            EventListenerList<E> eventListenerList = this.sourceListeners.get(s);
            if (eventListenerList == null) {
                return false;
            }
            boolean bl = eventListenerList.removeListener(eventListener);
            if (eventListenerList.size() == 0) {
                this.sourceListeners.remove(s);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListeners(S s) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            return this.sourceListeners.remove(s) != null;
        }
    }
}

