/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.InspectionUtils;
import org.limewire.inspection.Inspector;

@Singleton
public class InspectorImpl
implements Inspector {
    private volatile Properties props;
    private final Injector injector;
    private final AtomicBoolean loading = new AtomicBoolean(false);

    @Inject
    InspectorImpl(Injector injector) {
        this.injector = injector;
    }

    public Object inspect(String string) throws InspectionException {
        String string2 = this.props == null || !this.props.containsKey(string) ? string : this.props.getProperty(string);
        return InspectionUtils.inspectValue(string2, this.injector);
    }

    public boolean loaded() {
        return this.props != null && !this.props.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        if (this.loading.getAndSet(true)) {
            return;
        }
        BufferedReader bufferedReader = null;
        Properties properties = new Properties();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) continue;
                properties.setProperty(stringArray[0], stringArray[1]);
            }
            this.props = properties;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

