/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnewayExchanger<V, E extends Throwable> {
    private static final Object THIS = new Object();
    private final Object lock;
    private final boolean oneShot;
    private boolean done = false;
    private boolean cancelled = false;
    private V value;
    private E exception;

    public OnewayExchanger() {
        this(THIS, false);
    }

    public OnewayExchanger(Object object) {
        this(object, false);
    }

    public OnewayExchanger(boolean bl) {
        this(THIS, bl);
    }

    public OnewayExchanger(Object object, boolean bl) {
        this.lock = object != THIS ? object : this;
        this.oneShot = bl;
    }

    public Object getLock() {
        return this.lock;
    }

    public V get() throws InterruptedException, E {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, E {
        Object object = this.lock;
        synchronized (object) {
            if (!this.done) {
                if (l == 0L) {
                    this.lock.wait();
                } else {
                    timeUnit.timedWait(this.lock, l);
                }
                if (!this.done) {
                    throw new TimeoutException();
                }
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V tryGet() throws InterruptedException, E {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return this.get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return this.cancelled;
            }
            this.done = true;
            this.cancelled = true;
            this.lock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean throwsException() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled || this.exception != null;
        }
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(V v) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return false;
            }
            if (this.done && this.oneShot) {
                return false;
            }
            this.done = true;
            this.value = v;
            this.lock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setException(E e) {
        Object object = this.lock;
        synchronized (object) {
            if (e == null) {
                throw new NullPointerException();
            }
            if (this.cancelled) {
                return false;
            }
            if (this.done && this.oneShot) {
                return false;
            }
            this.done = true;
            this.exception = e;
            this.lock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.oneShot && this.done) {
                this.done = false;
                this.cancelled = false;
                this.value = null;
                this.exception = null;
                return true;
            }
            return false;
        }
    }
}

