/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.RunnableListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListeningFutureTask<V>
extends FutureTask<V>
implements RunnableListeningFuture<V> {
    private final AtomicReference<EventListenerList<FutureEvent<V>>> listenersRef = new AtomicReference(new EventListenerList());
    private final EventListenerList.EventListenerListContext listenerContext = this.listenersRef.get().getContext();

    public ListeningFutureTask(Callable<V> callable) {
        super(callable);
    }

    public ListeningFutureTask(Runnable runnable, V v) {
        super(runnable, v);
    }

    @Override
    protected void done() {
        EventListenerList eventListenerList = this.listenersRef.getAndSet(null);
        assert (eventListenerList != null);
        if (eventListenerList.size() > 0) {
            eventListenerList.broadcast(FutureEvent.createEvent(this));
        }
    }

    @Override
    public void addFutureListener(EventListener<FutureEvent<V>> eventListener) {
        boolean bl = false;
        EventListenerList<FutureEvent<V>> eventListenerList = this.listenersRef.get();
        if (!this.isDone() && eventListenerList != null) {
            eventListenerList.addListener(new ProxyListener<V>(eventListener, this.listenerContext));
            bl = this.listenersRef.compareAndSet(eventListenerList, eventListenerList);
        }
        if (!bl) {
            EventListenerList.dispatch(eventListener, FutureEvent.createEvent(this), this.listenerContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyListener<V>
    implements EventListener<FutureEvent<V>> {
        private final AtomicBoolean called = new AtomicBoolean(false);
        private final EventListenerList.EventListenerListContext listenerContext;
        private final EventListener<FutureEvent<V>> delegate;

        public ProxyListener(EventListener<FutureEvent<V>> eventListener, EventListenerList.EventListenerListContext eventListenerListContext) {
            this.delegate = eventListener;
            this.listenerContext = eventListenerListContext;
        }

        @Override
        public void handleEvent(FutureEvent<V> futureEvent) {
            if (!this.called.getAndSet(true)) {
                EventListenerList.dispatch(this.delegate, futureEvent, this.listenerContext);
            }
        }
    }
}

