/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureEvent<V> {
    private final Type type;
    private final V result;
    private final ExecutionException exception;

    private FutureEvent(Type type, V v, ExecutionException executionException) {
        this.type = type;
        this.result = v;
        this.exception = executionException;
    }

    public static <V> FutureEvent<V> createEvent(Future<V> future) {
        assert (future.isDone());
        boolean bl = future.isCancelled();
        V v = null;
        ExecutionException executionException = null;
        if (!bl) {
            try {
                v = future.get();
            }
            catch (ExecutionException executionException2) {
                executionException = executionException2;
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
        if (bl) {
            return FutureEvent.createCancelled();
        }
        if (executionException != null) {
            return FutureEvent.createException(executionException);
        }
        return FutureEvent.createSuccess(v);
    }

    public static <V> FutureEvent<V> createCancelled() {
        return new FutureEvent<Object>(Type.CANCELLED, null, null);
    }

    public static <V> FutureEvent<V> createSuccess(V v) {
        return new FutureEvent<V>(Type.SUCCESS, v, null);
    }

    public static <V> FutureEvent<V> createException(ExecutionException executionException) {
        return new FutureEvent<Object>(Type.EXCEPTION, null, executionException);
    }

    public Type getType() {
        return this.type;
    }

    public V getResult() {
        return this.result;
    }

    public ExecutionException getException() {
        return this.exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SUCCESS,
        EXCEPTION,
        CANCELLED;

    }
}

