/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.limewire.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ErrorCatchingThreadPoolExecutor
extends ThreadPoolExecutor {
    public ErrorCatchingThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, rejectedExecutionHandler);
    }

    public ErrorCatchingThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
    }

    public ErrorCatchingThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    public ErrorCatchingThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    @Override
    public <T> Future<T> submit(final Callable<T> callable) {
        return super.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return callable.call();
                }
                catch (RuntimeException runtimeException) {
                    ExceptionUtils.reportOrReturn(runtimeException);
                    throw runtimeException;
                }
                catch (Error error) {
                    ExceptionUtils.reportOrReturn(error);
                    throw error;
                }
            }
        });
    }

    @Override
    public Future<?> submit(final Runnable runnable) {
        return super.submit(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.reportOrReturn(throwable);
                    ExceptionUtils.rethrow(throwable);
                }
            }
        });
    }

    @Override
    public <T> Future<T> submit(final Runnable runnable, T t) {
        return super.submit(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.reportOrReturn(throwable);
                    ExceptionUtils.rethrow(throwable);
                }
            }
        }, t);
    }
}

