/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.limewire.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractErrorCatchingExecutorService
extends AbstractExecutorService {
    AbstractErrorCatchingExecutorService() {
    }

    @Override
    public <T> Future<T> submit(final Callable<T> callable) {
        return super.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return callable.call();
                }
                catch (RuntimeException runtimeException) {
                    ExceptionUtils.reportOrReturn(runtimeException);
                    throw runtimeException;
                }
                catch (Error error) {
                    ExceptionUtils.reportOrReturn(error);
                    throw error;
                }
            }
        });
    }

    @Override
    public Future<?> submit(final Runnable runnable) {
        return super.submit(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.reportOrReturn(throwable);
                    ExceptionUtils.rethrow(throwable);
                }
            }
        });
    }

    @Override
    public <T> Future<T> submit(final Runnable runnable, T t) {
        return super.submit(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.reportOrReturn(throwable);
                    ExceptionUtils.rethrow(throwable);
                }
            }
        }, t);
    }
}

