/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.limewire.collection.Trie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrieUtils {
    private TrieUtils() {
    }

    public static <K, V> List<V> select(Trie<K, V> trie, K k, int n) {
        return TrieUtils.select(trie, k, n, null);
    }

    public static <K, V> List<V> select(Trie<K, V> trie, K k, int n, final Trie.Cursor<K, V> cursor) {
        final int n2 = Math.min(trie.size(), n);
        final ArrayList arrayList = new ArrayList(n2);
        trie.select(k, new Trie.Cursor<K, V>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends K, ? extends V> entry) {
                if (cursor == null || cursor.select(entry) == Trie.Cursor.SelectStatus.EXIT) {
                    arrayList.add(entry.getValue());
                }
                return arrayList.size() >= n2 ? Trie.Cursor.SelectStatus.EXIT : Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return arrayList;
    }
}

