/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.limewire.collection.EmptyIterator;
import org.limewire.collection.Function;
import org.limewire.collection.TrieEdge;
import org.limewire.collection.TrieNode;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTrie<V> {
    private TrieNode<V> root;
    private boolean ignoreCase;

    public StringTrie(boolean bl) {
        this.ignoreCase = bl;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String string) {
        if (!this.ignoreCase) {
            return string;
        }
        return string.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String string, int n, int n2, String string2) {
        int n3 = n;
        for (int i = 0; i < string2.length(); ++i) {
            if (n3 >= n2) {
                return i;
            }
            if (string.charAt(n3) != string2.charAt(i)) {
                return i;
            }
            ++n3;
        }
        return -1;
    }

    public V add(String string, V v) {
        Object object;
        Object object2;
        string = this.canonicalCase(string);
        TrieNode<Object> trieNode = this.root;
        for (int i = 0; i < string.length(); i += ((String)object2).length()) {
            object = trieNode.get(string.charAt(i));
            if (object == null) {
                object2 = new TrieNode<V>(v);
                trieNode.put(string.substring(i), (TrieNode<Object>)object2);
                return null;
            }
            object2 = ((TrieEdge)object).getLabel();
            int n = this.match(string, i, string.length(), (String)object2);
            assert (n != 0) : "Label didn't start with prefix[0].";
            if (n >= 0) {
                TrieNode trieNode2 = ((TrieEdge)object).getChild();
                TrieNode<Object> trieNode3 = new TrieNode<Object>();
                String string2 = ((String)object2).substring(0, n);
                String string3 = ((String)object2).substring(n);
                String string4 = string.substring(i + n);
                if (string4.length() > 0) {
                    TrieNode<V> trieNode4 = new TrieNode<V>(v);
                    trieNode.remove(((String)object2).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.put(string4, trieNode4);
                } else {
                    trieNode.remove(((String)object2).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.setValue(v);
                }
                return null;
            }
            assert (n == -1) : "Bad return value from match: " + i;
            trieNode = ((TrieEdge)object).getChild();
        }
        object = trieNode.getValue();
        trieNode.setValue(v);
        return (V)object;
    }

    private TrieNode<V> fetch(String string) {
        String string2;
        TrieNode<V> trieNode = this.root;
        for (int i = 0; i < string.length(); i += string2.length()) {
            TrieEdge<V> trieEdge = trieNode.get(string.charAt(i));
            if (trieEdge == null) {
                return null;
            }
            string2 = trieEdge.getLabel();
            int n = this.match(string, i, string.length(), string2);
            assert (n != 0) : "Label didn't start with prefix[0].";
            if (n != -1) {
                return null;
            }
            trieNode = trieEdge.getChild();
        }
        return trieNode;
    }

    public V get(String string) {
        TrieNode<V> trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return null;
        }
        return trieNode.getValue();
    }

    public boolean remove(String string) {
        TrieNode<V> trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return false;
        }
        boolean bl = trieNode.getValue() != null;
        trieNode.setValue(null);
        return bl;
    }

    public Iterator<V> getPrefixedBy(String string) {
        string = this.canonicalCase(string);
        return this.getPrefixedBy(string, 0, string.length());
    }

    public Iterator<V> getPrefixedBy(String string, int n, int n2) {
        String string2;
        TrieNode<V> trieNode = this.root;
        for (int i = n; i < n2; i += string2.length()) {
            TrieEdge<V> trieEdge = trieNode.get(string.charAt(i));
            if (trieEdge == null) {
                return EmptyIterator.emptyIterator();
            }
            trieNode = trieEdge.getChild();
            string2 = trieEdge.getLabel();
            int n3 = this.match(string, i, n2, string2);
            assert (n3 != 0) : "Label didn't start with prefix[0].";
            if (i + n3 == n2) break;
            if (n3 >= 0) {
                trieNode = null;
                break;
            }
            assert (n3 == -1) : "Bad return value from match: " + i;
        }
        if (trieNode == null) {
            return EmptyIterator.emptyIterator();
        }
        return new ValueIterator(trieNode);
    }

    public Iterator<V> getIterator() {
        return new ValueIterator(this.root);
    }

    public int size() {
        int n = 0;
        Iterator<V> iterator = this.getIterator();
        while (iterator.hasNext()) {
            ++n;
        }
        return n;
    }

    public void trim(Function<V, ? extends V> function) throws IllegalArgumentException, ClassCastException {
        if (function != null) {
            NodeIterator nodeIterator = new NodeIterator(this.root, true);
            while (nodeIterator.hasNext()) {
                TrieNode trieNode = (TrieNode)nodeIterator.next();
                trieNode.trim();
                Object e = trieNode.getValue();
                if (e == null) continue;
                trieNode.setValue(function.apply(e));
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<root>");
        this.toStringHelper(this.root, stringBuilder, 1);
        return stringBuilder.toString();
    }

    private void toStringHelper(TrieNode trieNode, StringBuilder stringBuilder, int n) {
        if (trieNode.getValue() != null) {
            stringBuilder.append(" -> ");
            stringBuilder.append(trieNode.getValue().toString());
        }
        stringBuilder.append("\n");
        Iterator<String> iterator = trieNode.labelsForward();
        while (iterator.hasNext()) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(" ");
            }
            String string = iterator.next();
            stringBuilder.append(string);
            TrieNode trieNode2 = trieNode.get(string.charAt(0)).getChild();
            this.toStringHelper(trieNode2, stringBuilder, n + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeIterator
    extends UnmodifiableIterator<TrieNode<V>> {
        private ArrayList<Iterator<TrieNode<V>>> stack = new ArrayList();
        private TrieNode<V> nextNode;
        private boolean withNulls;

        public NodeIterator(TrieNode<V> trieNode, boolean bl) {
            this.withNulls = bl;
            if (bl || trieNode.getValue() != null) {
                this.nextNode = trieNode;
            } else {
                this.nextNode = null;
                this.advance(trieNode);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty() || this.nextNode != null;
        }

        @Override
        public TrieNode<V> next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            TrieNode trieNode = this.nextNode;
            this.nextNode = null;
            this.advance(trieNode);
            return trieNode;
        }

        private void advance(TrieNode<V> trieNode) {
            Iterator iterator = trieNode.childrenForward();
            while (true) {
                if (iterator.hasNext()) {
                    trieNode = iterator.next();
                    if (iterator.hasNext()) {
                        this.stack.add(iterator);
                    }
                    if (this.withNulls || trieNode.getValue() == null) {
                        iterator = trieNode.childrenForward();
                        continue;
                    }
                    this.nextNode = trieNode;
                    return;
                }
                int n = this.stack.size();
                if (n == 0) {
                    return;
                }
                iterator = this.stack.remove(n - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends UnmodifiableIterator<V> {
        private NodeIterator delegate;

        ValueIterator(TrieNode<V> trieNode) {
            this.delegate = new NodeIterator(trieNode, false);
        }

        @Override
        public V next() {
            return ((TrieNode)this.delegate.next()).getValue();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

