/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.LinkedList;
import org.limewire.collection.NumericBuffer;

public class QueueCounter {
    private LinkedList<Long> arrivals = new LinkedList();
    private NumericBuffer<Long> timesInSystem;
    private NumericBuffer<Long> interarrivalTimes;
    private long lastArrival;

    public QueueCounter(int n) {
        this.timesInSystem = new NumericBuffer(n);
        this.interarrivalTimes = new NumericBuffer(n);
    }

    public synchronized void recordArrival() {
        long l = System.nanoTime();
        if (!this.arrivals.isEmpty()) {
            this.interarrivalTimes.add(l - this.lastArrival);
        }
        this.arrivals.addLast(l);
        this.lastArrival = l;
    }

    public synchronized void recordDeparture() {
        this.timesInSystem.add(System.nanoTime() - this.arrivals.removeFirst());
    }

    public synchronized double getAverageSize() {
        if (this.timesInSystem.getSize() < this.timesInSystem.getCapacity()) {
            return -1.0;
        }
        return this.timesInSystem.average().doubleValue() / this.interarrivalTimes.average().doubleValue();
    }

    public synchronized boolean isStale() {
        if (this.timesInSystem.size() < this.timesInSystem.getCapacity()) {
            return false;
        }
        if (!this.arrivals.isEmpty()) {
            return false;
        }
        return System.nanoTime() - this.lastArrival > this.interarrivalTimes.sum().longValue() + (Long)this.timesInSystem.last();
    }

    public synchronized void reset() {
        this.timesInSystem.clear();
        this.interarrivalTimes.clear();
        this.arrivals.clear();
        this.lastArrival = 0L;
    }
}

