/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericBuffer<T extends Number>
extends Buffer<T> {
    public NumericBuffer(int n) {
        super(n);
    }

    public NumericBuffer(Buffer<? extends T> buffer) {
        super(buffer);
    }

    @Override
    protected T[] createArray(int n) {
        return new Number[n + 1];
    }

    public Number average() {
        if (this.isEmpty()) {
            return 0;
        }
        Number number = this.sum();
        if (number instanceof Double) {
            return this.sum().doubleValue() / (double)this.size();
        }
        return this.sum().longValue() / (long)this.size();
    }

    public Number sum() {
        if (this.isEmpty()) {
            return new Integer(0);
        }
        Number number = (Number)this.first();
        if (number instanceof Float || number instanceof Double) {
            return this.doubleSum();
        }
        return this.longSum();
    }

    private double doubleSum() {
        double d = 0.0;
        for (Number number : (Number[])this.buf) {
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    private long longSum() {
        long l = 0L;
        for (Number number : (Number[])this.buf) {
            if (number == null) continue;
            l += number.longValue();
        }
        return l;
    }
}

