/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIterator<T>
implements Iterator<T> {
    protected final Iterator<? extends T>[] iterators;
    protected int current;

    public MultiIterator(Iterator<? extends T> iterator) {
        this.iterators = new Iterator[]{iterator};
    }

    public MultiIterator(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        this.iterators = new Iterator[]{iterator, iterator2};
    }

    public MultiIterator(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        this.iterators = new Iterator[]{iterator, iterator2, iterator3};
    }

    public MultiIterator(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4) {
        this.iterators = new Iterator[]{iterator, iterator2, iterator3, iterator4};
    }

    public MultiIterator(Iterator<? extends T> ... iteratorArray) {
        this.iterators = iteratorArray;
    }

    @Override
    public void remove() {
        if (this.iterators.length == 0) {
            throw new IllegalStateException();
        }
        this.iterators[this.current].remove();
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.iterators.length; ++i) {
            if (!this.iterators[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.iterators.length == 0) {
            throw new NoSuchElementException();
        }
        this.positionCurrent();
        return this.iterators[this.current].next();
    }

    protected void positionCurrent() {
        while (!this.iterators[this.current].hasNext() && this.current < this.iterators.length) {
            ++this.current;
        }
    }
}

