/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashMap<V> {
    private transient Entry<V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public LongHashMap() {
        this(20, 0.75f);
    }

    public LongHashMap(int n) {
        this(n, 0.75f);
    }

    public LongHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public LongHashMap(LongHashMap<? extends V> longHashMap) {
        this((int)((double)(1 + longHashMap.size()) * 1.1));
        this.putAll(longHashMap);
    }

    public void putAll(LongHashMap<? extends V> longHashMap) {
        Entry<V>[] entryArray = longHashMap.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<V> entry = entryArray[n];
            while (entry != null) {
                this.put(entry.key, entry.value);
                entry = entry.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<V>[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<V> entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(long l) {
        Entry<V>[] entryArray = this.table;
        int n = (int)l;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public V get(long l) {
        Entry<V>[] entryArray = this.table;
        int n = (int)l;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<V>[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry<V> entry = entryArray[n3];
            while (entry != null) {
                Entry<V> entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public V put(long l, V v) {
        Entry<V>[] entryArray = this.table;
        int n = (int)l;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == l) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry<V>(n, l, v, entryArray[n2]);
        ++this.count;
        return null;
    }

    public V remove(long l) {
        Entry<V>[] entryArray = this.table;
        int n = (int)l;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<V> entry = entryArray[n2];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key == l) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object v = entry.value;
                entry.value = null;
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<V>[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        int hash;
        long key;
        V value;
        Entry<V> next;

        protected Entry(int n, long l, V v, Entry<V> entry) {
            this.hash = n;
            this.key = l;
            this.value = v;
            this.next = entry;
        }
    }
}

