/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPartitioner<E> {
    private final List<E> list;
    private final int numPartitions;

    public ListPartitioner(List<E> list, int n) {
        assert (n > 0);
        this.list = list;
        this.numPartitions = n;
    }

    public List<E> getPartition(int n) {
        if (n >= this.numPartitions) {
            throw new NoSuchElementException();
        }
        if (this.numPartitions == 1) {
            return this.list;
        }
        if (this.list.isEmpty()) {
            return Collections.emptyList();
        }
        int n2 = this.list.size() / this.numActivePartitions();
        if (n2 * n >= this.list.size()) {
            return Collections.emptyList();
        }
        int n3 = n2 * (n + 1);
        if (this.list.size() - n3 <= n2 && n == this.numPartitions - 1) {
            n3 = this.list.size();
        }
        return this.list.subList(n2 * n, n3);
    }

    public List<E> getLastPartition() {
        return this.getPartition(this.numActivePartitions() - 1);
    }

    private int numActivePartitions() {
        return Math.min(this.list.size(), this.numPartitions);
    }

    public List<E> getFirstPartition() {
        return this.getPartition(0);
    }
}

