/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.Map;
import org.limewire.collection.NoMoreStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedsizeHashMap<K, V> {
    private final Map<K, V> hashMap;
    private final int maxSize;

    public FixedsizeHashMap(int n) {
        this.hashMap = new HashMap(n * 4 / 3);
        this.maxSize = n;
    }

    public synchronized V put(K k, V v) throws NoMoreStorageException {
        V v2 = null;
        if (this.hashMap.size() < this.maxSize) {
            v2 = this.hashMap.put(k, v);
        } else {
            v2 = this.hashMap.get(k);
            if (v2 != null) {
                v2 = this.hashMap.put(k, v);
            } else {
                throw new NoMoreStorageException();
            }
        }
        return v2;
    }

    public synchronized V get(K k) {
        return this.hashMap.get(k);
    }

    public synchronized void clear() {
        this.hashMap.clear();
    }

    public synchronized String toString() {
        return this.hashMap.toString();
    }
}

