/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedsizeForgetfulHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final int MAXIMUM_SIZE;

    public FixedsizeForgetfulHashMap(int n) {
        this(n, n * 4 / 3 + 10, 0.75f);
    }

    public FixedsizeForgetfulHashMap(int n, int n2) {
        this(n, n2, 0.75f);
    }

    public FixedsizeForgetfulHashMap(int n, int n2, float f) {
        super(n2, f);
        if (n < 1) {
            throw new IllegalArgumentException("invalid size: " + n);
        }
        this.MAXIMUM_SIZE = n;
    }

    public boolean isFull() {
        return this.size() >= this.MAXIMUM_SIZE;
    }

    public Map.Entry<K, V> removeLRUEntry() {
        if (this.isEmpty()) {
            return null;
        }
        Iterator iterator = this.entrySet().iterator();
        Map.Entry entry = iterator.next();
        iterator.remove();
        return entry;
    }

    @Override
    public FixedsizeForgetfulHashMap<K, V> clone() {
        return (FixedsizeForgetfulHashMap)super.clone();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.MAXIMUM_SIZE;
    }

    @Override
    public V put(K k, V v) {
        V v2 = null;
        if (this.containsKey(k)) {
            v2 = this.remove(k);
        }
        super.put(k, v);
        return v2;
    }
}

