/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer<E>
implements Cloneable,
Iterable<E> {
    private final int size;
    protected E[] buf;
    private int head;
    private int tail;

    public Buffer(int n) {
        assert (n >= 1);
        this.size = n + 1;
        this.head = 0;
        this.tail = 0;
    }

    public Buffer(Buffer<? extends E> buffer) {
        this.size = buffer.size;
        this.head = buffer.head;
        this.tail = buffer.tail;
        if (buffer.buf != null) {
            this.buf = this.createArray(buffer.buf.length);
            System.arraycopy(buffer.buf, 0, this.buf, 0, buffer.buf.length);
        }
    }

    protected E[] createArray(int n) {
        return new Object[n];
    }

    protected void initialize() {
        if (this.buf == null) {
            this.buf = this.createArray(this.size + 1);
        }
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int n) {
        if (n == 0) {
            return this.size - 1;
        }
        return n - 1;
    }

    private int increment(int n) {
        if (n == this.size - 1) {
            return 0;
        }
        return n + 1;
    }

    private int index(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getSize()) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return (n + this.head) % this.size;
    }

    public E get(int n) throws IndexOutOfBoundsException {
        this.initialize();
        return this.buf[this.index(n)];
    }

    public void set(int n, E e) throws IndexOutOfBoundsException {
        this.initialize();
        this.buf[this.index((int)n)] = e;
    }

    public E add(E e) {
        return this.addFirst(e);
    }

    public E addFirst(E e) {
        this.initialize();
        E e2 = null;
        if (this.isFull()) {
            e2 = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = e;
        return e2;
    }

    public E addLast(E e) {
        this.initialize();
        E e2 = null;
        if (this.isFull()) {
            e2 = this.removeFirst();
        }
        this.buf[this.tail] = e;
        this.tail = this.increment(this.tail);
        return e2;
    }

    public boolean contains(Object object) {
        for (E e : this) {
            if (!e.equals(object)) continue;
            return true;
        }
        return false;
    }

    public E first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public E last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public E removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        E e = this.buf[this.head];
        this.buf[this.head] = null;
        this.head = this.increment(this.head);
        return e;
    }

    public E removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        E e = this.buf[this.tail];
        this.buf[this.tail] = null;
        return e;
    }

    public E remove(int n) throws IndexOutOfBoundsException {
        E e = this.get(n);
        int n2 = this.index(n);
        while (n2 != this.tail) {
            this.buf[n2] = this.buf[this.increment(n2)];
            n2 = this.increment(n2);
        }
        this.tail = this.decrement(this.tail);
        this.buf[this.tail] = null;
        return e;
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!object.equals(this.get(i))) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeAll(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!object.equals(this.get(i))) continue;
            this.remove(i);
            --i;
            bl = true;
        }
        return bl;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new BufferIterator();
    }

    public Buffer<E> clone() {
        return new Buffer<E>(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean bl = true;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(iterator.next().toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BufferIterator
    extends UnmodifiableIterator<E> {
        int i;
        int oldHead;
        int oldTail;

        BufferIterator() {
            this.i = Buffer.this.head;
            this.oldHead = Buffer.this.head;
            this.oldTail = Buffer.this.tail;
        }

        @Override
        public boolean hasNext() {
            this.ensureNoModifications();
            return this.i != Buffer.this.tail;
        }

        @Override
        public E next() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = Buffer.this.buf[this.i];
            this.i = Buffer.this.increment(this.i);
            return e;
        }

        private void ensureNoModifications() {
            if (this.oldHead != Buffer.this.head || this.oldTail != Buffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

