/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

public class BitNumbers {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] MASKS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private byte[] data;
    private final int size;
    public static final BitNumbers EMPTY_BN = new ImmutableBitNumbers();

    public BitNumbers(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length * 8;
    }

    public BitNumbers(int n) {
        this.size = n;
    }

    public BitNumbers(String string) throws IllegalArgumentException {
        this.data = new byte[(int)Math.ceil((double)string.length() / 2.0)];
        this.size = this.data.length * 8;
        for (int i = 0; i < string.length(); i += 2) {
            boolean bl = i == string.length() - 1;
            int n = Integer.parseInt(string.substring(i, bl ? i + 1 : i + 2), 16);
            if (bl) {
                n <<= 4;
            }
            assert (n <= 255);
            this.data[i / 2] = (byte)n;
        }
    }

    public boolean isSet(int n) {
        if (n >= this.size) {
            return false;
        }
        int n2 = (int)Math.floor((double)n / 8.0);
        int n3 = n % 8;
        return this.data != null && n2 < this.data.length && (this.data[n2] & MASKS[n3]) != 0;
    }

    public int getMax() {
        return this.size;
    }

    public void set(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("idx: " + n + ", max: " + this.size);
        }
        int n2 = (int)Math.floor((double)n / 8.0);
        int n3 = n % 8;
        if (this.data == null) {
            this.data = new byte[(int)Math.ceil((double)this.size / 8.0)];
        }
        int n4 = n2;
        this.data[n4] = (byte)(this.data[n4] | MASKS[n3]);
    }

    public byte[] toByteArray() {
        if (this.data == null) {
            return EMPTY;
        }
        int n = this.getLastNonZeroIndex();
        if (n == -1) {
            return EMPTY;
        }
        if (n == this.data.length - 1) {
            return this.data;
        }
        byte[] byArray = new byte[n + 1];
        System.arraycopy(this.data, 0, byArray, 0, n + 1);
        return byArray;
    }

    public boolean isEmpty() {
        if (this.data == null) {
            return true;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toHexString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.data.length * 2);
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            String string;
            if (this.data[i] != 0) {
                n = i;
            }
            if ((string = Integer.toHexString(this.data[i] & 0xFF)).length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string.toUpperCase());
        }
        stringBuilder.setLength(n * 2 + 2);
        if (stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private int getLastNonZeroIndex() {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (this.data[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.toHexString();
    }

    public static BitNumbers synchronizedBitNumbers(BitNumbers bitNumbers) {
        return new SynchronizedBitNumbers(bitNumbers);
    }

    private static class SynchronizedBitNumbers
    extends BitNumbers {
        private final BitNumbers delegate;

        private SynchronizedBitNumbers(BitNumbers bitNumbers) {
            super(0);
            this.delegate = bitNumbers;
        }

        public synchronized boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public synchronized int getMax() {
            return this.delegate.getMax();
        }

        public synchronized boolean isSet(int n) {
            return this.delegate.isSet(n);
        }

        public synchronized void set(int n) {
            this.delegate.set(n);
        }

        public synchronized byte[] toByteArray() {
            return this.delegate.toByteArray();
        }

        public synchronized String toHexString() {
            return this.delegate.toHexString();
        }

        public synchronized String toString() {
            return this.delegate.toString();
        }
    }

    private static class ImmutableBitNumbers
    extends BitNumbers {
        public void set(int n) {
            throw new UnsupportedOperationException("immutable!");
        }

        ImmutableBitNumbers() {
            super(0);
        }
    }
}

