/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

class AckMessageImpl
extends RUDPMessageImpl
implements AckMessage {
    private long _windowStart;
    private int _windowSpace;

    AckMessageImpl(byte by, long l, long l2, int n) {
        super(by, RUDPMessage.OpCode.OP_ACK, l, (short)(l2 & 0xFFFFL), (short)(n < 0 ? 0 : n & 0xFFFF));
        this._windowStart = l2;
        this._windowSpace = n;
    }

    AckMessageImpl(byte by, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_ACK, by, l, byteBuffer, byteBuffer2);
        if (byteBuffer.remaining() < 4) {
            throw new MessageFormatException("Message not long enough, message length " + byteBuffer.remaining() + " < 4");
        }
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this._windowStart = byteBuffer.getShort();
        this._windowSpace = byteBuffer.getShort();
        byteBuffer.rewind();
    }

    public long getWindowStart() {
        return this._windowStart;
    }

    public void extendWindowStart(long l) {
        this._windowStart = l;
    }

    public int getWindowSpace() {
        return this._windowSpace;
    }

    public String toString() {
        return "AckMessage DestID:" + this.getConnectionID() + " start:" + this._windowStart + " space:" + this._windowSpace + " seq:" + this.getSequenceNumber();
    }
}

