/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.rudp.UDPConnectionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UDPTimerEvent
implements Comparable<UDPTimerEvent> {
    private static final Log LOG = LogFactory.getLog(UDPTimerEvent.class);
    protected volatile long _eventTime;
    private volatile boolean _shouldUnregister;
    protected final WeakReference<UDPConnectionProcessor> _udpCon;

    UDPTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
        this._eventTime = l;
        this._udpCon = new WeakReference<UDPConnectionProcessor>(uDPConnectionProcessor);
    }

    final boolean shouldUnregister() {
        if (this._udpCon.get() == null || this._shouldUnregister) {
            LOG.debug((Object)"Event decided to unregister itself");
            return true;
        }
        return false;
    }

    protected final void unregister() {
        this._shouldUnregister = true;
        this._eventTime = 1L;
    }

    public void updateTime(long l) {
        if (!this._shouldUnregister) {
            this._eventTime = l;
        }
    }

    public long getEventTime() {
        return this._eventTime;
    }

    public final void handleEvent() {
        UDPConnectionProcessor uDPConnectionProcessor = (UDPConnectionProcessor)this._udpCon.get();
        if (uDPConnectionProcessor == null) {
            return;
        }
        this.doActualEvent(uDPConnectionProcessor);
    }

    protected abstract void doActualEvent(UDPConnectionProcessor var1);

    @Override
    public int compareTo(UDPTimerEvent uDPTimerEvent) {
        long l = uDPTimerEvent._eventTime - this._eventTime;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + " [eventTime=" + this._eventTime + "]";
    }
}

