/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.UDPSelectionKey;
import org.limewire.rudp.UDPSocketChannel;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPMultiplexor
extends AbstractSelector {
    private static final Log LOG = LogFactory.getLog(UDPMultiplexor.class);
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile UDPSocketChannel[] _channels;
    private final List<SelectableChannel> channelsToRemove = new LinkedList<SelectableChannel>();
    private Set<SelectionKey> selectedKeys = new HashSet<SelectionKey>(256);
    private int _lastConnectionID;
    private final RUDPContext context;

    UDPMultiplexor(SelectorProvider selectorProvider, RUDPContext rUDPContext) {
        super(selectorProvider);
        this.context = rUDPContext;
        this._channels = new UDPSocketChannel[256];
        this._lastConnectionID = 0;
    }

    public boolean isConnectedTo(InetAddress inetAddress) {
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        if (this._lastConnectionID == 0) {
            return false;
        }
        for (int i = 0; i < uDPSocketChannelArray.length; ++i) {
            UDPSocketChannel uDPSocketChannel = uDPSocketChannelArray[i];
            if (uDPSocketChannel == null || !inetAddress.equals(uDPSocketChannel.getRemoteSocketAddress().getAddress())) continue;
            return true;
        }
        return false;
    }

    public void routeMessage(RUDPMessage rUDPMessage, InetSocketAddress inetSocketAddress) {
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        int n = rUDPMessage.getConnectionID() & 0xFF;
        UDPSocketChannel uDPSocketChannel = null;
        if (n == 0 && rUDPMessage instanceof SynMessage) {
            for (int i = 1; i < uDPSocketChannelArray.length; ++i) {
                uDPSocketChannel = uDPSocketChannelArray[i];
                if (uDPSocketChannel == null || !uDPSocketChannel.isConnectionPending() || !uDPSocketChannel.getRemoteSocketAddress().equals(inetSocketAddress)) continue;
                uDPSocketChannel.getProcessor().handleMessage(rUDPMessage);
                break;
            }
        } else if (uDPSocketChannelArray[n] != null && (uDPSocketChannel = uDPSocketChannelArray[n]).getRemoteSocketAddress().equals(inetSocketAddress)) {
            uDPSocketChannel.getProcessor().handleMessage(rUDPMessage);
        }
        if (uDPSocketChannel != null && uDPSocketChannel.getProcessor().readyOps() != 0) {
            this.context.getTransportListener().eventPending();
        }
    }

    @Override
    protected void implCloseSelector() throws IOException {
        throw new IllegalStateException("should never be closed.");
    }

    @Override
    protected synchronized SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        int n2;
        if (!(abstractSelectableChannel instanceof UDPSocketChannel)) {
            throw new IllegalSelectorException();
        }
        UDPSocketChannel uDPSocketChannel = (UDPSocketChannel)abstractSelectableChannel;
        UDPSocketChannel[] uDPSocketChannelArray = new UDPSocketChannel[this._channels.length];
        for (n2 = 0; n2 < this._channels.length; ++n2) {
            uDPSocketChannelArray[n2] = this._channels[n2];
        }
        for (n2 = 1; n2 <= uDPSocketChannelArray.length; ++n2) {
            int n3 = (this._lastConnectionID + n2) % 256;
            if (n3 == 0 || uDPSocketChannelArray[n3] != null) continue;
            this._lastConnectionID = n3;
            uDPSocketChannelArray[n3] = uDPSocketChannel;
            uDPSocketChannel.getProcessor().setConnectionId((byte)n3);
            this._channels = uDPSocketChannelArray;
            return new UDPSelectionKey(this, object, abstractSelectableChannel, n);
        }
        LOG.warn((Object)"Attempting to add over connection limit");
        this.channelsToRemove.add(abstractSelectableChannel);
        return new UDPSelectionKey(this, object, abstractSelectableChannel, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SelectionKey> keys() {
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        HashSet<SelectionKey> hashSet = new HashSet<SelectionKey>();
        for (int i = 0; i < uDPSocketChannelArray.length; ++i) {
            if (uDPSocketChannelArray[i] == null) continue;
            hashSet.add(uDPSocketChannelArray[i].keyFor(this));
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            for (SelectableChannel selectableChannel : this.channelsToRemove) {
                hashSet.add(selectableChannel.keyFor(this));
            }
        }
        return hashSet;
    }

    @Override
    public int select() throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    @Override
    public int select(long l) throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNow() throws IOException {
        Object object;
        UDPSocketChannel[] uDPSocketChannelArray = this._channels;
        UDPSocketChannel[] uDPSocketChannelArray2 = null;
        this.selectedKeys.clear();
        for (int i = 0; i < uDPSocketChannelArray.length; ++i) {
            UDPSelectionKey uDPSelectionKey;
            object = uDPSocketChannelArray[i];
            if (object == null || (uDPSelectionKey = (UDPSelectionKey)((AbstractSelectableChannel)object).keyFor(this)) == null) continue;
            if (uDPSelectionKey.isValid() && ((AbstractInterruptibleChannel)object).isOpen()) {
                int n = ((UDPSocketChannel)object).getProcessor().readyOps();
                int n2 = n & uDPSelectionKey.interestOps();
                if (n2 == 0) continue;
                uDPSelectionKey.setReadyOps(n2);
                this.selectedKeys.add(uDPSelectionKey);
                continue;
            }
            if (uDPSocketChannelArray2 == null) {
                uDPSocketChannelArray2 = new UDPSocketChannel[uDPSocketChannelArray.length];
            }
            uDPSocketChannelArray2[i] = object;
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            if (uDPSocketChannelArray2 != null) {
                object = new UDPSocketChannel[this._channels.length];
                for (int i = 0; i < this._channels.length; ++i) {
                    object[i] = this._channels[i] == uDPSocketChannelArray2[i] ? null : this._channels[i];
                }
                this._channels = object;
            }
            if (!this.channelsToRemove.isEmpty()) {
                for (SelectableChannel selectableChannel : this.channelsToRemove) {
                    UDPSelectionKey uDPSelectionKey = (UDPSelectionKey)selectableChannel.keyFor(this);
                    uDPSelectionKey.cancel();
                    uDPSelectionKey.setReadyOps(0);
                    this.selectedKeys.add(uDPSelectionKey);
                }
                this.channelsToRemove.clear();
            }
        }
        return this.selectedKeys.size();
    }

    @Override
    public Selector wakeup() {
        return this;
    }
}

