/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.rudp.DataRecord;
import org.limewire.rudp.DataWindow;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.SequenceNumberExtender;
import org.limewire.rudp.UDPScheduler;
import org.limewire.rudp.UDPSocketChannel;
import org.limewire.rudp.UDPTimerEvent;
import org.limewire.rudp.WriteRegulator;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.service.ErrorService;

public class UDPConnectionProcessor {
    private static final Log LOG = LogFactory.getLog(UDPConnectionProcessor.class);
    public static final int DATA_CHUNK_SIZE = 512;
    private static final int MAX_DATA_SIZE = 4096;
    private static final int DATA_WINDOW_SIZE = 20;
    private static final int DATA_WRITE_AHEAD_MAX = 25;
    private static final int MAX_SEND_TRIES = 8;
    private static final long SYN_WAIT_TIME = 400L;
    private static final long MAX_CONNECT_WAIT_TIME = 20000L;
    private static final long MAX_KEEPALIVE_TIME = 60000L;
    private static final long KEEPALIVE_WAIT_TIME = 2500L;
    private static final long DEFAULT_RTO_WAIT_TIME = 400L;
    private static final long MAX_MESSAGE_WAIT_TIME = 20000L;
    private static final long MIN_ACK_WAIT_TIME = 5L;
    static final long SMALL_SEND_WINDOW = 2L;
    private static final long MAX_WRITE_WITHOUT_SLEEP = 4L;
    private static final long WRITE_WAKEUP_DELAY_TIME = 10L;
    private static final long NOTHING_TO_DO_DELAY = 1000L;
    private static final long SHUTDOWN_DELAY_TIME = 400L;
    private static final long CHANNEL_SHUTDOWN_DELAY = 30000L;
    private static final int PRECONNECT_STATE = 0;
    private static final int CONNECTING_STATE = 1;
    private static final int CONNECT_STATE = 2;
    private static final int FIN_STATE = 3;
    private UDPScheduler _scheduler;
    private UDPSocketChannel _channel;
    private InetSocketAddress _connectedTo;
    private volatile int _chunkLimit;
    private volatile int _receiverWindowSpace;
    private boolean _receivedSynAck;
    private DataWindow _sendWindow;
    private WriteRegulator _writeRegulator;
    private DataWindow _receiveWindow;
    private byte _myConnectionID;
    private volatile byte _theirConnectionID;
    private int _connectionState;
    private UDPTimerEvent _keepaliveEvent;
    private UDPTimerEvent _writeDataEvent;
    private UDPTimerEvent _closedCleanupEvent;
    private boolean _waitingForDataSpace;
    private volatile boolean _waitingForDataAvailable;
    private boolean _waitingForFinAck;
    private long _startedConnecting;
    private UDPTimerEvent _connectEvent;
    private UDPTimerEvent _ackTimeoutEvent;
    private UDPTimerEvent _safeWriteWakeup;
    private long _sequenceNumber;
    private long _finSeqNo;
    private SequenceNumberExtender _localExtender;
    private SequenceNumberExtender _extender;
    private long _lastSendTime;
    private long _lastDataSendTime;
    private long _lastReceivedTime;
    private long _lastDataOrAckTime;
    private int _ackResendCount;
    private boolean _skipADataWrite;
    private byte _closeReasonCode;
    private final boolean _skipAcks;
    private final int _period;
    private final int _periodHistory;
    private final float _deviation;
    private final int _maxSkipAck;
    private final int[] _periods;
    private int _currentPeriodId;
    private int _packetsThisPeriod;
    private boolean _enoughData;
    private long _lastPeriod;
    private int _skippedAcks;
    private int _skippedAcksTotal;
    private int _totalDataPackets;
    private final RUDPContext _context;

    protected UDPConnectionProcessor(UDPSocketChannel uDPSocketChannel, RUDPContext rUDPContext) {
        this._context = rUDPContext;
        this._theirConnectionID = 0;
        this._connectionState = 0;
        this._lastSendTime = 0L;
        this._lastDataSendTime = 0L;
        this._chunkLimit = 20;
        this._receiverWindowSpace = 20;
        this._waitingForDataSpace = false;
        this._waitingForDataAvailable = false;
        this._waitingForFinAck = false;
        this._skipADataWrite = false;
        this._ackResendCount = 0;
        this._closeReasonCode = 0;
        this._channel = uDPSocketChannel;
        this._scheduler = UDPScheduler.instance();
        this._receiveWindow = new DataWindow(20, 1L);
        this._localExtender = new SequenceNumberExtender();
        this._extender = new SequenceNumberExtender();
        this._skipAcks = this._context.getRUDPSettings().isSkipAcksEnabled();
        this._maxSkipAck = this._context.getRUDPSettings().getMaxSkipAcks();
        this._deviation = this._context.getRUDPSettings().getMaxSkipDeviation();
        this._period = this._context.getRUDPSettings().getSkipAckPeriodLength();
        this._periodHistory = this._context.getRUDPSettings().getSkipAckHistorySize();
        this._periods = new int[this._periodHistory];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(InetSocketAddress inetSocketAddress) throws IOException {
        if (!this._context.getUDPService().isListening() || !this._context.getUDPService().isNATTraversalCapable()) {
            throw new IOException("udp isn't working");
        }
        UDPConnectionProcessor uDPConnectionProcessor = this;
        synchronized (uDPConnectionProcessor) {
            if (this._connectionState != 0) {
                if (this.isConnected()) {
                    throw new AlreadyConnectedException();
                }
                if (this.isClosed()) {
                    throw new ClosedChannelException();
                }
                throw new ConnectionPendingException();
            }
            this._connectionState = 1;
        }
        this._connectedTo = inetSocketAddress;
        this._startedConnecting = System.currentTimeMillis();
        this._sequenceNumber = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to: " + inetSocketAddress));
        }
        this.tryToConnect();
    }

    protected void setConnectionId(byte by) {
        this._myConnectionID = by;
    }

    protected InetSocketAddress getSocketAddress() {
        return this._connectedTo;
    }

    protected DataWindow getReadWindow() {
        return this._receiveWindow;
    }

    protected synchronized int readyOps() {
        if (this.isClosed()) {
            return 255;
        }
        return (this.isConnectReady() ? 8 : 0) | (this.isReadReady() ? 1 : 0) | (this.isWriteReady() ? 4 : 0);
    }

    private boolean isConnectReady() {
        return this._receivedSynAck && this.isConnecting() && this._theirConnectionID != 0;
    }

    private boolean isReadReady() {
        return this._receiveWindow.hasReadableData();
    }

    private boolean isWriteReady() {
        return this.isConnected() && this._channel.getNumberOfPendingChunks() < this.getChunkLimit();
    }

    protected synchronized void close() throws IOException {
        if (this._connectionState == 3) {
            throw new IOException("already closed");
        }
        if (this._connectEvent != null) {
            this._connectEvent.unregister();
        }
        if (this._keepaliveEvent != null) {
            this._keepaliveEvent.unregister();
        }
        if (this._writeDataEvent != null) {
            this._writeDataEvent.unregister();
        }
        if (this._ackTimeoutEvent != null) {
            this._ackTimeoutEvent.unregister();
        }
        if (this._safeWriteWakeup != null) {
            this._safeWriteWakeup.unregister();
        }
        int n = this._connectionState;
        this._connectionState = 3;
        this._waitingForFinAck = true;
        if (n != 0) {
            this.safeSendFin();
            if (this._closedCleanupEvent == null) {
                this._closedCleanupEvent = new ClosedConnectionCleanupTimerEvent(System.currentTimeMillis() + 400L, this);
                LOG.debug((Object)"registering a closedCleanupEvent");
                this._scheduler.register(this._closedCleanupEvent);
            }
        }
    }

    private synchronized void finalClose() {
        if (this._waitingForFinAck) {
            this.safeSendFin();
        }
        this._closedCleanupEvent.unregister();
        this._scheduler.register(new ChannelCloseTimerEvent(System.currentTimeMillis() + 30000L, this));
    }

    protected synchronized boolean prepareOpenConnection() throws IOException {
        if (this.isClosed()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            return true;
        }
        if (!this._receivedSynAck || this._theirConnectionID == 0) {
            return false;
        }
        this._connectionState = 2;
        this._sequenceNumber = 1L;
        this.scheduleKeepAlive();
        this._sendWindow = new DataWindow(20, 1L);
        this._writeRegulator = new WriteRegulator(this._sendWindow);
        this._safeWriteWakeup = new SafeWriteWakeupTimerEvent(Long.MAX_VALUE, this);
        this._scheduler.register(this._safeWriteWakeup);
        this._chunkLimit = this._sendWindow.getWindowSpace();
        return true;
    }

    private synchronized void scheduleKeepAlive() {
        this._keepaliveEvent = new KeepAliveTimerEvent(this._lastSendTime + 2500L, this);
        this._scheduler.register(this._keepaliveEvent);
        this._scheduler.scheduleEvent(this._keepaliveEvent);
    }

    private synchronized void scheduleWriteDataEvent(long l) {
        if (this.isConnected()) {
            if (this._writeDataEvent == null) {
                this._writeDataEvent = new WriteDataTimerEvent(l, this);
                this._scheduler.register(this._writeDataEvent);
            } else {
                this._writeDataEvent.updateTime(l);
            }
            this._scheduler.scheduleEvent(this._writeDataEvent);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("scheduleWriteDataEvent :" + l));
            }
        }
    }

    private synchronized void writeSpaceActivation() {
        if (this._waitingForDataSpace) {
            this._waitingForDataSpace = false;
            this.scheduleWriteDataEvent(0L);
        }
    }

    private synchronized void writeDataActivation() {
        long l = this._sendWindow.getRTO();
        this.scheduleWriteDataEvent(this._lastDataSendTime + l / 4L);
    }

    protected void wakeupWriteEvent(boolean bl) {
        if (bl || this._waitingForDataAvailable) {
            LOG.debug((Object)"wakupWriteEvent");
            if (this._safeWriteWakeup.getEventTime() == Long.MAX_VALUE) {
                this._safeWriteWakeup.updateTime(System.currentTimeMillis() + 10L);
                this._scheduler.scheduleEvent(this._safeWriteWakeup);
            }
        }
    }

    private synchronized void scheduleConnectEvent(long l) {
        if (this._connectEvent == null) {
            this._connectEvent = new ConnectSynEvent(l, this);
            this._scheduler.register(this._connectEvent);
        } else {
            this._connectEvent.updateTime(l);
        }
        this._scheduler.scheduleEvent(this._connectEvent);
    }

    private synchronized void scheduleAckTimeoutEvent(long l) {
        if (this.isConnected()) {
            if (this._ackTimeoutEvent == null) {
                this._ackTimeoutEvent = new AckTimeoutTimerEvent(l, this);
                this._scheduler.register(this._ackTimeoutEvent);
            } else {
                this._ackTimeoutEvent.updateTime(l);
            }
            this._scheduler.scheduleEvent(this._ackTimeoutEvent);
        }
    }

    private synchronized void unscheduleAckTimeoutEvent() {
        if (this._ackTimeoutEvent == null) {
            return;
        }
        this._ackTimeoutEvent.updateTime(Long.MAX_VALUE);
    }

    private synchronized boolean isAckTimeoutUpdateRequired() {
        if (this._ackTimeoutEvent == null) {
            return true;
        }
        return this._ackTimeoutEvent.getEventTime() == Long.MAX_VALUE;
    }

    protected synchronized boolean isConnected() {
        return this._connectionState == 2 && this._theirConnectionID != 0;
    }

    protected synchronized boolean isClosed() {
        return this._connectionState == 3;
    }

    protected synchronized boolean isConnecting() {
        return !this.isClosed() && (this._connectionState == 1 || this._connectionState != 0 && this._theirConnectionID == 0);
    }

    protected int getChunkLimit() {
        return Math.min(this._chunkLimit, this._receiverWindowSpace);
    }

    protected void sendKeepAlive() {
        KeepAliveMessage keepAliveMessage = null;
        try {
            keepAliveMessage = this._context.getMessageFactory().createKeepAliveMessage(this._theirConnectionID, this._receiveWindow.getWindowStart(), this._receiveWindow.getWindowSpace());
            this.send(keepAliveMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorService.error((Throwable)illegalArgumentException);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void sendData(ByteBuffer byteBuffer) {
        try {
            assert (byteBuffer.position() == 0);
            DataMessage dataMessage = this._context.getMessageFactory().createDataMessage(this._theirConnectionID, this._sequenceNumber, byteBuffer);
            this.send(dataMessage);
            DataRecord dataRecord = this._sendWindow.addData(dataMessage);
            dataRecord.sentTime = this._lastSendTime;
            ++dataRecord.sends;
            if (LOG.isDebugEnabled() && this._lastSendTime - this._lastDataSendTime > 2000L) {
                LOG.debug((Object)("SendData lag = " + (this._lastSendTime - this._lastDataSendTime)));
            }
            this._lastDataSendTime = this._lastSendTime;
            this._chunkLimit = this._sendWindow.getWindowSpace();
            ++this._sequenceNumber;
            if (this.isAckTimeoutUpdateRequired()) {
                this.scheduleAckTimeoutIfNeeded();
            }
            if (this._receiverWindowSpace > 0) {
                --this._receiverWindowSpace;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorService.error((Throwable)illegalArgumentException);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSendAck(RUDPMessage rUDPMessage) {
        AckMessage ackMessage = null;
        try {
            ackMessage = this._context.getMessageFactory().createAckMessage(this._theirConnectionID, rUDPMessage.getSequenceNumber(), this._receiveWindow.getWindowStart(), this._receiveWindow.getWindowSpace());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("total data packets " + this._totalDataPackets + " total acks skipped " + this._skippedAcksTotal + " skipped this session " + this._skippedAcks));
            }
            this._skippedAcks = 0;
            this.send(ackMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorService.error((Throwable)illegalArgumentException);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSendFin() {
        FinMessage finMessage = null;
        try {
            this._finSeqNo = this._sequenceNumber;
            finMessage = this._context.getMessageFactory().createFinMessage(this._theirConnectionID, this._sequenceNumber, this._closeReasonCode);
            this.send(finMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorService.error((Throwable)illegalArgumentException);
            LOG.warn((Object)"calling recursively closeAndCleanup");
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSend(RUDPMessage rUDPMessage) {
        try {
            this.send(rUDPMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorService.error((Throwable)illegalArgumentException);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void send(RUDPMessage rUDPMessage) throws IllegalArgumentException {
        this._lastSendTime = System.currentTimeMillis();
        if (rUDPMessage instanceof DataMessage || rUDPMessage instanceof AckMessage) {
            this._lastDataOrAckTime = this._lastSendTime;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send:" + rUDPMessage + " to: " + this._connectedTo + ", t:" + this._lastSendTime));
            if (rUDPMessage instanceof FinMessage) {
                Exception exception = new Exception();
                LOG.debug((Object)"", (Throwable)exception);
            }
        }
        this._context.getUDPService().send(rUDPMessage, this._connectedTo);
    }

    private synchronized void scheduleAckTimeoutIfNeeded() {
        DataRecord dataRecord = this._sendWindow.getOldestUnackedBlock();
        if (dataRecord != null) {
            int n = this._sendWindow.getRTO();
            if (n == 0) {
                n = 400;
            }
            long l = dataRecord.sentTime + (long)n;
            if (this._ackResendCount > 0) {
                l = this._lastSendTime + (long)n;
                this._ackResendCount = 0;
            }
            long l2 = System.currentTimeMillis() + 5L;
            l = Math.max(l, l2);
            this.scheduleAckTimeoutEvent(l);
        } else {
            this.unscheduleAckTimeoutEvent();
        }
    }

    private synchronized void validateAckedData() {
        long l = System.currentTimeMillis();
        if (this._sendWindow.acksAppearToBeMissing(l, 1)) {
            int n = this._sendWindow.getRTO();
            long l2 = this._sendWindow.getWindowStart();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Soft resend check:" + l2 + " rto:" + n + " uS:" + this._sendWindow.getUsedSpots() + " localSeq:" + this._sequenceNumber));
            }
            int n2 = 0;
            DataRecord dataRecord = this._sendWindow.getOldestUnackedBlock();
            int n3 = n * (int)Math.pow(2.0, dataRecord.sends - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" exponential backoff is now " + n3));
            }
            if (this._sendWindow.countHigherAckBlocks() > 0) {
                n3 = (int)((double)n3 * 0.75);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" higher acked blocks, adjusting exponential backoff is now " + n3));
                }
            }
            if (dataRecord.acks <= 0) {
                if (dataRecord.sends > 9) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Tried too many send on:" + dataRecord.msg.getSequenceNumber()));
                    }
                    this.closeAndCleanup((byte)4);
                    return;
                }
                int n4 = (int)(l - dataRecord.sentTime);
                if (n4 > n3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Soft resending message:" + dataRecord.msg.getSequenceNumber()));
                    }
                    this.safeSend(dataRecord.msg);
                    this._writeRegulator.addMessageFailure();
                    this._writeRegulator.hitResendTimeout();
                    dataRecord.sentTime = l = this._lastSendTime;
                    ++dataRecord.sends;
                    ++n2;
                } else {
                    LOG.debug((Object)" not resending message ");
                }
            }
            this._ackResendCount = n2;
            if (n2 > 0) {
                this._skipADataWrite = true;
            }
        }
        this.scheduleAckTimeoutIfNeeded();
    }

    private synchronized void closeAndCleanup(byte by) {
        this._closeReasonCode = by;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void tryToConnect() {
        if (!this.isConnecting()) {
            LOG.debug((Object)"Already connected");
            if (this._connectEvent != null) {
                this._connectEvent.unregister();
            }
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this._startedConnecting;
        if (l2 > 20000L) {
            LOG.debug((Object)("Timed out, waited for: " + l2));
            this._connectionState = 3;
            this._channel.eventPending();
        } else {
            if (this._myConnectionID != 0) {
                SynMessage synMessage = this._theirConnectionID != 0 ? this._context.getMessageFactory().createSynMessage(this._myConnectionID, this._theirConnectionID) : this._context.getMessageFactory().createSynMessage(this._myConnectionID);
                LOG.debug((Object)("Sending SYN: " + synMessage));
                this.send(synMessage);
            }
            this.scheduleConnectEvent(l + 400L);
        }
    }

    private void handleSynMessage(SynMessage synMessage) {
        synMessage.extendSequenceNumber(this._extender.extendSequenceNumber(synMessage.getSequenceNumber()));
        byte by = synMessage.getSenderConnectionID();
        if (this._theirConnectionID == 0) {
            this._theirConnectionID = by;
        } else if (this._theirConnectionID != by) {
            return;
        }
        this.safeSendAck(synMessage);
    }

    private void handleAckMessage(AckMessage ackMessage) {
        ackMessage.extendSequenceNumber(this._localExtender.extendSequenceNumber(ackMessage.getSequenceNumber()));
        ackMessage.extendWindowStart(this._localExtender.extendSequenceNumber(ackMessage.getWindowStart()));
        long l = ackMessage.getSequenceNumber();
        long l2 = ackMessage.getWindowStart();
        int n = this._receiverWindowSpace;
        this._receiverWindowSpace = ackMessage.getWindowSpace();
        if (this._sequenceNumber > l2) {
            this._receiverWindowSpace = 20 + (int)(l2 - this._sequenceNumber);
        }
        if ((n == 0 || this._waitingForDataSpace) && this._receiverWindowSpace > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" -- ACK wakeup");
            }
            this.writeSpaceActivation();
        }
        if (l == 0L && this.isConnecting()) {
            this._receivedSynAck = true;
        } else if (this._waitingForFinAck && l == this._finSeqNo) {
            this._waitingForFinAck = false;
        } else if (this._connectionState == 2) {
            this._sendWindow.ackBlock(l);
            this._writeRegulator.addMessageSuccess();
            this._sendWindow.pseudoAckToReceiverWindow(ackMessage.getWindowStart());
            this._sendWindow.clearLowAckedBlocks(this._channel);
            this._chunkLimit = this._sendWindow.getWindowSpace();
        }
    }

    private void handleDataMessage(DataMessage dataMessage) {
        dataMessage.extendSequenceNumber(this._extender.extendSequenceNumber(dataMessage.getSequenceNumber()));
        long l = dataMessage.getSequenceNumber();
        long l2 = this._receiveWindow.getWindowStart();
        if (dataMessage.getDataLength() > 4096) {
            this.closeAndCleanup((byte)3);
            return;
        }
        if (l > l2 + 25L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received block num too far ahead: " + l));
            }
            return;
        }
        DataRecord dataRecord = null;
        if (l >= l2) {
            dataRecord = this._receiveWindow.addData(dataMessage);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received duplicate block num: " + dataMessage.getSequenceNumber()));
        }
        if (this._lastPeriod == 0L) {
            this._lastPeriod = this._lastReceivedTime;
        }
        ++this._packetsThisPeriod;
        ++this._totalDataPackets;
        if (this.shouldSendAck()) {
            if (dataRecord != null) {
                dataRecord.ackTime = System.currentTimeMillis();
                ++dataRecord.acks;
            }
            this.safeSendAck(dataMessage);
        }
        if (this._lastReceivedTime - this._lastPeriod >= (long)this._period) {
            this._lastPeriod = this._lastReceivedTime;
            ++this._currentPeriodId;
            if (this._currentPeriodId >= this._periodHistory) {
                this._currentPeriodId = 0;
                this._enoughData = true;
            }
            this._periods[this._currentPeriodId] = this._packetsThisPeriod;
            this._packetsThisPeriod = 0;
        }
    }

    private boolean shouldSendAck() {
        if (this._skipAcks && this._enoughData && this._skippedAcks < this._maxSkipAck) {
            float f = 0.0f;
            for (int i = 0; i < this._periodHistory; ++i) {
                f += (float)this._periods[i];
            }
            if ((float)this._periods[this._currentPeriodId] > (f /= (float)this._periodHistory) / this._deviation) {
                ++this._skippedAcks;
                ++this._skippedAcksTotal;
                return false;
            }
        }
        return true;
    }

    private void handleKeepAliveMessage(KeepAliveMessage keepAliveMessage) {
        keepAliveMessage.extendWindowStart(this._localExtender.extendSequenceNumber(keepAliveMessage.getWindowStart()));
        long l = keepAliveMessage.getWindowStart();
        int n = this._receiverWindowSpace;
        this._receiverWindowSpace = keepAliveMessage.getWindowSpace();
        if (this._sequenceNumber > l) {
            this._receiverWindowSpace = 20 + (int)(l - this._sequenceNumber);
        }
        if (this.isClosed()) {
            this.safeSendFin();
        }
        if (this._sendWindow != null) {
            this._sendWindow.pseudoAckToReceiverWindow(l);
            this._sendWindow.clearLowAckedBlocks(this._channel);
            this._chunkLimit = this._sendWindow.getWindowSpace();
            if ((n == 0 || this._waitingForDataSpace) && this._receiverWindowSpace > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)" -- KA wakeup");
                }
                this.writeSpaceActivation();
            }
        }
    }

    private void handleFinMessage(FinMessage finMessage) {
        finMessage.extendSequenceNumber(this._extender.extendSequenceNumber(finMessage.getSequenceNumber()));
        this._receiverWindowSpace = 0;
        this.safeSendAck(finMessage);
        if (!this.isClosed()) {
            this.closeAndCleanup((byte)1);
        }
    }

    protected synchronized void handleMessage(RUDPMessage rUDPMessage) {
        this._lastReceivedTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("handleMessage :" + rUDPMessage + " t:" + this._lastReceivedTime));
        }
        if (rUDPMessage instanceof SynMessage) {
            this.handleSynMessage((SynMessage)rUDPMessage);
        } else if (rUDPMessage instanceof AckMessage) {
            this._lastDataOrAckTime = this._lastReceivedTime;
            this.handleAckMessage((AckMessage)rUDPMessage);
        } else if (rUDPMessage instanceof DataMessage) {
            this._lastDataOrAckTime = this._lastReceivedTime;
            this.handleDataMessage((DataMessage)rUDPMessage);
        } else if (rUDPMessage instanceof KeepAliveMessage) {
            this.handleKeepAliveMessage((KeepAliveMessage)rUDPMessage);
        } else if (rUDPMessage instanceof FinMessage) {
            this.handleFinMessage((FinMessage)rUDPMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeData() {
        long l;
        int n = 0;
        while (true) {
            Object object;
            this._waitingForDataAvailable = false;
            this._waitingForDataSpace = false;
            if (this._skipADataWrite) {
                this._skipADataWrite = false;
            } else if (this.getChunkLimit() > 0) {
                object = this._channel.getNextChunk();
                if (object != null) {
                    this.sendData((ByteBuffer)object);
                }
            } else {
                this.scheduleWriteDataEvent(System.currentTimeMillis() + 1000L);
                this._waitingForDataSpace = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Shutdown SendData cL:" + this._chunkLimit + " rWS:" + this._receiverWindowSpace));
                }
                return;
            }
            object = this._channel.writeLock();
            synchronized (object) {
                if (this._channel.getNumberOfPendingChunks() == 0) {
                    this.scheduleWriteDataEvent(System.currentTimeMillis() + 1000L);
                    this._waitingForDataAvailable = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Shutdown SendData no pending");
                    }
                    return;
                }
            }
            long l2 = System.currentTimeMillis();
            l = this._writeRegulator.getSleepTime(l2, this._receiverWindowSpace);
            if ((long)this._receiverWindowSpace <= 2L && this._receiverWindowSpace <= 1) {
                this._writeRegulator.hitZeroWindow();
            }
            if (l == 0L && this._sequenceNumber < 10L) {
                l = 400L;
            }
            if ((long)n >= 4L) {
                ++l;
            }
            if (l > 0L) break;
            ++n;
        }
        long l3 = System.currentTimeMillis() + l;
        this.scheduleWriteDataEvent(l3);
    }

    static class ChannelCloseTimerEvent
    extends UDPTimerEvent {
        public ChannelCloseTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            try {
                uDPConnectionProcessor._channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unregister();
        }
    }

    static class ClosedConnectionCleanupTimerEvent
    extends UDPTimerEvent {
        public ClosedConnectionCleanupTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closed connection timeout: " + System.currentTimeMillis()));
            }
            uDPConnectionProcessor.finalClose();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closed connection done: " + System.currentTimeMillis()));
            }
            this.unregister();
        }
    }

    static class ConnectSynEvent
    extends UDPTimerEvent {
        public ConnectSynEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            this._eventTime = Long.MAX_VALUE;
            LOG.debug((Object)"Running SYN Event");
            uDPConnectionProcessor.tryToConnect();
        }
    }

    static class SafeWriteWakeupTimerEvent
    extends UDPTimerEvent {
        public SafeWriteWakeupTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("write wakeup timeout: " + System.currentTimeMillis()));
            }
            if (uDPConnectionProcessor.isConnected()) {
                uDPConnectionProcessor.writeDataActivation();
            }
            this._eventTime = Long.MAX_VALUE;
            uDPConnectionProcessor._scheduler.scheduleEvent(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("write wakeup timeout: " + System.currentTimeMillis()));
            }
        }
    }

    static class AckTimeoutTimerEvent
    extends UDPTimerEvent {
        public AckTimeoutTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ack timeout: " + System.currentTimeMillis()));
            }
            if (uDPConnectionProcessor.isConnected()) {
                uDPConnectionProcessor.validateAckedData();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("end ack timeout: " + System.currentTimeMillis()));
            }
        }
    }

    static class WriteDataTimerEvent
    extends UDPTimerEvent {
        public WriteDataTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("data timeout :" + System.currentTimeMillis()));
            }
            long l = System.currentTimeMillis();
            if (uDPConnectionProcessor.isConnected() && uDPConnectionProcessor._lastReceivedTime + 20000L < l) {
                uDPConnectionProcessor.closeAndCleanup((byte)2);
                return;
            }
            if (uDPConnectionProcessor.isConnected()) {
                uDPConnectionProcessor.writeData();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("end data timeout: " + System.currentTimeMillis()));
            }
        }
    }

    static class KeepAliveTimerEvent
    extends UDPTimerEvent {
        public KeepAliveTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
            super(l, uDPConnectionProcessor);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
            long l = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("keepalive: " + l));
            }
            if (uDPConnectionProcessor.isClosed()) {
                uDPConnectionProcessor._keepaliveEvent.unregister();
                return;
            }
            if (uDPConnectionProcessor.isConnected() && (uDPConnectionProcessor._lastDataOrAckTime + 60000L < l || uDPConnectionProcessor._lastReceivedTime + 20000L < l)) {
                LOG.debug((Object)"Keepalive generated shutdown");
                uDPConnectionProcessor.closeAndCleanup((byte)2);
                return;
            }
            if (l + 1L >= uDPConnectionProcessor._lastSendTime + 2500L) {
                if (uDPConnectionProcessor.isConnected()) {
                    uDPConnectionProcessor.sendKeepAlive();
                } else {
                    return;
                }
            }
            this._eventTime = uDPConnectionProcessor._lastSendTime + 2500L;
            uDPConnectionProcessor._scheduler.scheduleEvent(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("end keepalive: " + System.currentTimeMillis()));
            }
        }
    }
}

