/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

public class SequenceNumberExtender {
    private static final long BASE_INCREMENT = 65536L;
    private static final long LOW_BASE_SWITCH_POINT = 32767L;
    private static final long HIGH_BASE_SWITCH_POINT = 16383L;
    private static final long BASE_MIDPOINT = 24575L;
    private long lowBase = 0L;
    private long highBase = 0L;
    private boolean highSwitchPending = true;
    private boolean lowSwitchPending = false;

    public SequenceNumberExtender() {
    }

    SequenceNumberExtender(long l) {
        this.lowBase = l &= 0xFFFFFFFFFFFF0000L;
        this.highBase = l;
    }

    public long extendSequenceNumber(long l) {
        if (l >= 16383L && l < 24575L && this.highSwitchPending) {
            this.highBase = this.lowBase;
            this.highSwitchPending = false;
            this.lowSwitchPending = true;
        }
        if (l > 32767L && this.lowSwitchPending) {
            this.lowBase += 65536L;
            this.highSwitchPending = true;
            this.lowSwitchPending = false;
        }
        long l2 = l < 16383L ? l + this.lowBase : l + this.highBase;
        return l2;
    }
}

