/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.ExecutorsHelper;

public class EventUtils {
    private static final AtomicReference<Thread> REF = new AtomicReference();
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "EventUtilsThread");
            thread.setDaemon(true);
            REF.set(thread);
            return thread;
        }
    };
    private static final ExecutorService EXECUTOR = ExecutorsHelper.newSingleThreadExecutor((ThreadFactory)FACTORY);

    private EventUtils() {
    }

    public static boolean isEventThread() {
        return REF.get() == Thread.currentThread();
    }

    public static void fireEvent(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }
}

