/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static String toString(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringBuilder.append(n).append(": ").append(iterator.next()).append('\n');
            ++n;
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static <T> Iterator<T> iterator(final Collection<T> collection, final int n) {
        return new Iterator<T>(){
            private final Iterator<T> it;
            private int item;
            {
                this.it = collection.iterator();
                this.item = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.item >= n) {
                    return false;
                }
                return this.it.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.item;
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
                --this.item;
            }
        };
    }

    public static <T> Collection<T> getCollection(Collection<T> collection) {
        return CollectionUtils.getCollection(collection, KademliaSettings.REPLICATION_PARAMETER.getValue());
    }

    public static <T> Collection<T> getCollection(final Collection<T> collection, final int n) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.iterator(collection, n);
            }

            @Override
            public int size() {
                return Math.min(collection.size(), n);
            }
        };
    }
}

