/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.concurrent.FutureEvent;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.BucketNode;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ExceptionUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteTableImpl
implements RouteTable {
    private static final long serialVersionUID = -7351267868357880369L;
    private static final Log LOG = LogFactory.getLog(RouteTableImpl.class);
    private final PatriciaTrie<KUID, Bucket> bucketTrie;
    private int consecutiveFailures = 0;
    private transient RouteTable.ContactPinger pinger;
    private Contact localNode;
    private volatile transient List<RouteTable.RouteTableListener> listeners = new CopyOnWriteArrayList<RouteTable.RouteTableListener>();
    private volatile transient DHTExecutorService notifier;

    public RouteTableImpl() {
        this(KUID.createRandomID());
    }

    public RouteTableImpl(byte[] byArray) {
        this(KUID.createWithBytes(byArray));
    }

    public RouteTableImpl(String string) {
        this(KUID.createWithHexString(string));
    }

    public RouteTableImpl(KUID kUID) {
        this.localNode = ContactFactory.createLocalContact(Vendor.UNKNOWN, Version.ZERO, kUID, 0, false);
        this.bucketTrie = new PatriciaTrie(KUID.KEY_ANALYZER);
        this.init();
    }

    private void init() {
        KUID kUID = KUID.MINIMUM;
        BucketNode bucketNode = new BucketNode(this, kUID, 0);
        this.bucketTrie.put((Object)kUID, (Object)bucketNode);
        this.addContactToBucket(bucketNode, this.localNode);
        this.consecutiveFailures = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new CopyOnWriteArrayList<RouteTable.RouteTableListener>();
        for (Bucket bucket : this.bucketTrie.values()) {
            ((BucketNode)bucket).postInit();
        }
    }

    @Override
    public void setContactPinger(RouteTable.ContactPinger contactPinger) {
        this.pinger = contactPinger;
    }

    @Override
    public void setNotifier(DHTExecutorService dHTExecutorService) {
        this.notifier = dHTExecutorService;
    }

    @Override
    public void addRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
        if (routeTableListener == null) {
            throw new NullPointerException("RouteTableListener is null");
        }
        this.listeners.add(routeTableListener);
    }

    @Override
    public void removeRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
        if (routeTableListener == null) {
            throw new NullPointerException("RouteTableListener is null");
        }
        this.listeners.remove(routeTableListener);
    }

    @Override
    public synchronized void add(Contact contact) {
        if (this.localNode.equals(contact)) {
            String string = "Cannot add the local Node: " + contact;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)string);
            }
            ErrorService.error((Throwable)new IllegalArgumentException(string));
            return;
        }
        if (contact.isFirewalled()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(contact + " is firewalled"));
            }
            return;
        }
        if (!ContactUtils.isSameAddressSpace(this.localNode, contact)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(contact + " is from a different IP address space than " + this.localNode));
            }
            return;
        }
        this.consecutiveFailures = 0;
        KUID kUID = contact.getNodeID();
        Bucket bucket = (Bucket)this.bucketTrie.select((Object)kUID);
        Contact contact2 = bucket.get(kUID);
        if (contact2 != null) {
            this.updateContactInBucket(bucket, contact2, contact);
        } else if (!bucket.isActiveFull()) {
            if (this.isOkayToAdd(bucket, contact)) {
                this.addContactToBucket(bucket, contact);
            } else if (!this.canSplit(bucket)) {
                this.addContactToBucketCache(bucket, contact);
            }
        } else if (this.split(bucket)) {
            this.add(contact);
        } else {
            this.replaceContactInBucket(bucket, contact);
        }
    }

    protected synchronized void updateContactInBucket(Bucket bucket, Contact contact, Contact contact2) {
        assert (contact.getNodeID().equals(contact2.getNodeID()));
        if (this.isLocalNode(contact)) {
            if (!this.isLocalNode(contact2)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(contact2 + " collides with " + contact));
                }
            } else {
                if (!(contact2 instanceof LocalContact)) {
                    String string = "Attempting to replace the local Node " + contact + " with " + contact2;
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)string);
                    }
                    throw new IllegalArgumentException(string);
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Updating " + contact + " with " + contact2));
                }
                bucket.updateContact(contact2);
                this.localNode = contact2;
                this.fireContactUpdate(bucket, contact, contact2);
            }
            return;
        }
        if (contact.isAlive() && !contact2.isAlive()) {
            return;
        }
        if (!contact.isAlive() || this.isLocalNode(contact2) || contact.equals(contact2) || ContactUtils.areLocalContacts(contact, contact2)) {
            contact2.updateWithExistingContact(contact);
            Contact contact3 = bucket.updateContact(contact2);
            assert (contact3 == contact);
            long l = System.currentTimeMillis() - bucket.getTimeStamp();
            if (bucket.containsCachedContact(contact2.getNodeID()) && l > RouteTableSettings.BUCKET_PING_LIMIT.getValue()) {
                this.pingLeastRecentlySeenNode(bucket);
            }
            this.touchBucket(bucket);
            this.fireContactUpdate(bucket, contact, contact2);
        } else if (contact2.isAlive() && !contact.hasBeenRecentlyAlive()) {
            this.doSpoofCheck(bucket, contact, contact2);
        }
    }

    protected synchronized void doSpoofCheck(Bucket bucket, final Contact contact, final Contact contact2) {
        DHTFutureAdapter<PingResult> dHTFutureAdapter = new DHTFutureAdapter<PingResult>(){

            @Override
            protected void operationComplete(FutureEvent<PingResult> futureEvent) {
                switch (futureEvent.getType()) {
                    case SUCCESS: {
                        this.handleFutureSuccess((PingResult)futureEvent.getResult());
                        break;
                    }
                    case EXCEPTION: {
                        this.handleExecutionException(futureEvent.getException());
                    }
                }
            }

            private void handleFutureSuccess(PingResult pingResult) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(contact2 + " is trying to spoof " + pingResult));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleExecutionException(ExecutionException executionException) {
                DHTTimeoutException dHTTimeoutException = ExceptionUtils.getCause(executionException, DHTTimeoutException.class);
                if (dHTTimeoutException == null) {
                    return;
                }
                KUID kUID = dHTTimeoutException.getNodeID();
                SocketAddress socketAddress = dHTTimeoutException.getSocketAddress();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(ContactUtils.toString(kUID, socketAddress) + " did not respond! Replacing it with " + contact2));
                }
                RouteTableImpl routeTableImpl = RouteTableImpl.this;
                synchronized (routeTableImpl) {
                    Bucket bucket = (Bucket)RouteTableImpl.this.bucketTrie.select((Object)kUID);
                    Contact contact3 = bucket.get(kUID);
                    if (contact3 != null && contact3.equals(contact)) {
                        contact2.updateWithExistingContact(contact3);
                        Contact contact22 = bucket.updateContact(contact2);
                        assert (contact22 == contact3);
                        RouteTableImpl.this.fireContactUpdate(bucket, contact3, contact2);
                        if (bucket.containsCachedContact(kUID)) {
                            RouteTableImpl.this.pingLeastRecentlySeenNode(bucket);
                        }
                    } else {
                        RouteTableImpl.this.add(contact2);
                    }
                }
            }
        };
        this.fireContactCheck(bucket, contact, contact2);
        this.ping(contact, dHTFutureAdapter);
        this.touchBucket(bucket);
    }

    protected synchronized void addContactToBucket(Bucket bucket, Contact contact) {
        bucket.addActiveContact(contact);
        this.fireActiveContactAdded(bucket, contact);
    }

    protected synchronized void addContactToBucketCache(Bucket bucket, Contact contact) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Adding " + contact + " to " + bucket + " replacement cache"));
        }
        Contact contact2 = bucket.addCachedContact(contact);
        this.fireCachedContactAdded(bucket, contact2, contact);
    }

    private boolean canSplit(Bucket bucket) {
        boolean bl = bucket.contains(this.getLocalNode().getNodeID());
        return bl || bucket.isInSmallestSubtree() || !bucket.isTooDeep();
    }

    protected synchronized boolean split(Bucket bucket) {
        if (this.canSplit(bucket)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Splitting bucket: " + bucket));
            }
            List<Bucket> list = bucket.split();
            assert (list.size() == 2);
            Bucket bucket2 = list.get(0);
            Bucket bucket3 = list.get(1);
            Bucket bucket4 = (Bucket)this.bucketTrie.put((Object)bucket2.getBucketID(), (Object)bucket2);
            assert (bucket4 == bucket);
            Bucket bucket5 = (Bucket)this.bucketTrie.put((Object)bucket3.getBucketID(), (Object)bucket3);
            assert (bucket5 == null);
            this.fireSplitBucket(bucket, bucket2, bucket3);
            return true;
        }
        return false;
    }

    protected synchronized void replaceContactInBucket(Bucket bucket, Contact contact) {
        Contact contact2;
        if (contact.isAlive() && this.isOkayToAdd(bucket, contact) && !this.isLocalNode(contact2 = bucket.getLeastRecentlySeenActiveContact()) && (contact2.isUnknown() || contact2.isDead() || contact.getTimeStamp() == 0x7FFFFFFFFFFFFFFEL)) {
            if (LOG.isTraceEnabled()) {
                LOG.info((Object)("Replacing " + contact2 + " with " + contact));
            }
            boolean bl = bucket.removeActiveContact(contact2.getNodeID());
            assert (bl);
            bucket.addActiveContact(contact);
            this.touchBucket(bucket);
            this.fireReplaceContact(bucket, contact2, contact);
            return;
        }
        this.addContactToBucketCache(bucket, contact);
        this.pingLeastRecentlySeenNode(bucket);
    }

    @Override
    public synchronized void handleFailure(KUID kUID, SocketAddress socketAddress) {
        if (kUID == null) {
            return;
        }
        if (kUID.equals(this.getLocalNode().getNodeID())) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Cannot handle local Node's errors: " + ContactUtils.toString(kUID, socketAddress)));
            }
            return;
        }
        Bucket bucket = (Bucket)this.bucketTrie.select((Object)kUID);
        Contact contact = bucket.get(kUID);
        if (contact == null) {
            return;
        }
        if (!contact.getContactAddress().equals(socketAddress)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(contact + " address and " + socketAddress + " do not match"));
            }
            return;
        }
        if (this.consecutiveFailures >= RouteTableSettings.MAX_CONSECUTIVE_FAILURES.getValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Ignoring node failure as it appears that we are disconnected");
            }
            return;
        }
        ++this.consecutiveFailures;
        contact.handleFailure();
        if (contact.isDead()) {
            if (bucket.containsActiveContact(kUID)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Removing " + contact + " and replacing it with the MRS Node from Cache"));
                }
                if (bucket.getCacheSize() > 0) {
                    Contact contact2 = null;
                    while ((contact2 = bucket.getMostRecentlySeenCachedContact()) != null) {
                        boolean bl = bucket.removeCachedContact(contact2.getNodeID());
                        assert (bl);
                        if (!this.isOkayToAdd(bucket, contact2)) continue;
                        bl = bucket.removeActiveContact(kUID);
                        assert (bl);
                        assert (!bucket.isActiveFull());
                        bucket.addActiveContact(contact2);
                        this.fireReplaceContact(bucket, contact, contact2);
                        break;
                    }
                } else if (contact.getFailures() >= RouteTableSettings.MAX_ACCEPT_NODE_FAILURES.getValue()) {
                    bucket.removeActiveContact(kUID);
                    assert (!bucket.isActiveFull());
                    this.fireRemoveContact(bucket, contact);
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Removing " + contact + " from Cache"));
                }
                boolean bl = bucket.removeCachedContact(kUID);
                assert (bl);
            }
        }
    }

    protected synchronized boolean isOkayToAdd(Bucket bucket, Contact contact) {
        boolean bl;
        ClassfulNetworkCounter classfulNetworkCounter = bucket.getClassfulNetworkCounter();
        boolean bl2 = bl = classfulNetworkCounter == null || classfulNetworkCounter.isOkayToAdd(contact);
        if (LOG.isTraceEnabled()) {
            if (bl) {
                LOG.trace((Object)("It's okay to add " + contact + " to " + bucket));
            } else {
                LOG.trace((Object)("It's NOT okay to add " + contact + " to " + bucket));
            }
        }
        return bl;
    }

    protected synchronized boolean remove(Contact contact) {
        return this.remove(contact.getNodeID());
    }

    protected synchronized boolean remove(KUID kUID) {
        return ((Bucket)this.bucketTrie.select((Object)kUID)).remove(kUID);
    }

    @Override
    public synchronized Bucket getBucket(KUID kUID) {
        return (Bucket)this.bucketTrie.select((Object)kUID);
    }

    @Override
    public synchronized Contact select(final KUID kUID) {
        final Contact[] contactArray = new Contact[]{null};
        this.bucketTrie.select((Object)kUID, (Trie.Cursor)new Trie.Cursor<KUID, Bucket>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                contactArray[0] = entry.getValue().select(kUID);
                if (contactArray[0] != null) {
                    return Trie.Cursor.SelectStatus.EXIT;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return contactArray[0];
    }

    @Override
    public synchronized Contact get(KUID kUID) {
        return ((Bucket)this.bucketTrie.select((Object)kUID)).get(kUID);
    }

    public synchronized Collection<Contact> select(KUID kUID, int n) {
        return this.select(kUID, n, RouteTable.SelectMode.ALL);
    }

    @Override
    public synchronized Collection<Contact> select(final KUID kUID, final int n, final RouteTable.SelectMode selectMode) {
        if (n == 0) {
            return Collections.emptyList();
        }
        final int n2 = RouteTableSettings.MAX_ACCEPT_NODE_FAILURES.getValue();
        final ArrayList<Contact> arrayList = new ArrayList<Contact>(n);
        this.bucketTrie.select((Object)kUID, (Trie.Cursor)new Trie.Cursor<KUID, Bucket>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                Collection<Contact> collection = null;
                collection = selectMode == RouteTable.SelectMode.ALIVE || selectMode == RouteTable.SelectMode.ALIVE_WITH_LOCAL ? bucket.select(kUID, bucket.getActiveSize()) : bucket.select(kUID, n);
                for (Contact contact : collection) {
                    if (arrayList.size() >= n) {
                        return Trie.Cursor.SelectStatus.EXIT;
                    }
                    if (selectMode == RouteTable.SelectMode.ALIVE && !contact.isAlive() || selectMode == RouteTable.SelectMode.ALIVE_WITH_LOCAL && !contact.isAlive() && !RouteTableImpl.this.isLocalNode(contact) || contact.isShutdown()) continue;
                    if (contact.isDead()) {
                        float f = (float)(n2 - contact.getFailures()) / (float)Math.max(1, n2);
                        if (Math.random() >= (double)f) continue;
                    }
                    arrayList.add(contact);
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        assert (arrayList.size() <= n) : "Expected " + n + " or less elements but is " + arrayList.size();
        return arrayList;
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        Collection<Contact> collection = this.getActiveContacts();
        Collection<Contact> collection2 = this.getCachedContacts();
        ArrayList<Contact> arrayList = new ArrayList<Contact>(collection.size() + collection2.size());
        arrayList.addAll(collection);
        arrayList.addAll(collection2);
        return arrayList;
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        ArrayList<Contact> arrayList = new ArrayList<Contact>();
        for (Bucket bucket : this.bucketTrie.values()) {
            arrayList.addAll(bucket.getActiveContacts());
        }
        return arrayList;
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        ArrayList<Contact> arrayList = new ArrayList<Contact>();
        for (Bucket bucket : this.bucketTrie.values()) {
            arrayList.addAll(bucket.getCachedContacts());
        }
        return arrayList;
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(final boolean bl) {
        KUID kUID = this.getLocalNode().getNodeID();
        final ArrayList<KUID> arrayList = new ArrayList<KUID>();
        this.bucketTrie.select((Object)kUID, (Trie.Cursor)new Trie.Cursor<KUID, Bucket>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                if (bl && bucket.contains(RouteTableImpl.this.getLocalNode().getNodeID())) {
                    return Trie.Cursor.SelectStatus.CONTINUE;
                }
                if (bl || bucket.isRefreshRequired()) {
                    KUID kUID = KUID.createPrefxNodeID(bucket.getBucketID(), bucket.getDepth());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Refreshing bucket:" + bucket + " with random ID: " + kUID));
                    }
                    arrayList.add(kUID);
                    RouteTableImpl.this.touchBucket(bucket);
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return arrayList;
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return Collections.unmodifiableCollection(this.bucketTrie.values());
    }

    private void touchBucket(Bucket bucket) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Touching bucket: " + bucket));
        }
        bucket.touch();
    }

    private void pingLeastRecentlySeenNode(Bucket bucket) {
        Contact contact = bucket.getLeastRecentlySeenActiveContact();
        if (!this.isLocalNode(contact)) {
            this.ping(contact, null);
        }
    }

    private void ping(Contact contact, DHTFutureAdapter<PingResult> dHTFutureAdapter) {
        RouteTable.ContactPinger contactPinger = this.pinger;
        if (contactPinger != null) {
            contactPinger.ping(contact, dHTFutureAdapter);
        } else {
            this.handleFailure(contact.getNodeID(), contact.getContactAddress());
            if (dHTFutureAdapter != null) {
                ExecutionException executionException = new ExecutionException(new DHTTimeoutException(contact.getNodeID(), contact.getContactAddress(), null, 0L));
                FutureEvent futureEvent = FutureEvent.createException((ExecutionException)executionException);
                dHTFutureAdapter.handleEvent((FutureEvent<PingResult>)futureEvent);
            }
        }
    }

    @Override
    public Contact getLocalNode() {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        return this.localNode;
    }

    @Override
    public boolean isLocalNode(Contact contact) {
        return contact.equals(this.getLocalNode());
    }

    @Override
    public synchronized int size() {
        return this.getActiveContacts().size() + this.getCachedContacts().size();
    }

    @Override
    public synchronized void clear() {
        this.bucketTrie.clear();
        this.fireClear();
        this.init();
    }

    @Override
    public synchronized void purge(long l) {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        if (l == -1L) {
            return;
        }
        long l2 = System.currentTimeMillis();
        for (Contact contact : this.getActiveContacts()) {
            if (this.isLocalNode(contact) || l2 - contact.getTimeStamp() < l) continue;
            this.remove(contact);
        }
        for (Contact contact : this.getCachedContacts()) {
            if (l2 - contact.getTimeStamp() < l) continue;
            this.remove(contact);
        }
        this.mergeBuckets();
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode purgeMode, RouteTable.PurgeMode ... purgeModeArray) {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        EnumSet<RouteTable.PurgeMode[]> enumSet = EnumSet.of(purgeMode, purgeModeArray);
        if (enumSet.contains((Object)RouteTable.PurgeMode.DROP_CACHE)) {
            this.dropCache();
        }
        if (enumSet.contains((Object)RouteTable.PurgeMode.PURGE_CONTACTS)) {
            this.purgeContacts();
        }
        if (enumSet.contains((Object)RouteTable.PurgeMode.MERGE_BUCKETS)) {
            this.mergeBuckets();
        }
        if (enumSet.contains((Object)RouteTable.PurgeMode.STATE_TO_UNKNOWN)) {
            this.changeStateToUnknown(this.getActiveContacts());
            this.changeStateToUnknown(this.getCachedContacts());
        }
    }

    private synchronized void dropCache() {
        for (Contact contact : this.getCachedContacts()) {
            this.remove(contact);
        }
    }

    private synchronized void purgeContacts() {
        this.bucketTrie.traverse((Trie.Cursor)new Trie.Cursor<KUID, Bucket>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                bucket.purge();
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
    }

    private synchronized void mergeBuckets() {
        Collection<Contact> collection = this.getActiveContacts();
        collection = ContactUtils.sortAliveToFailed(collection);
        Collection<Contact> collection2 = this.getCachedContacts();
        collection2 = ContactUtils.sort(collection2);
        this.clear();
        boolean bl = collection.remove(this.localNode);
        assert (bl);
        for (Contact contact : collection) {
            this.add(contact);
        }
        for (Contact contact : collection2) {
            this.add(contact);
        }
    }

    private synchronized void changeStateToUnknown(Collection<Contact> collection) {
        for (Contact contact : collection) {
            contact.unknown();
        }
    }

    protected void fireActiveContactAdded(Bucket bucket, Contact contact) {
        this.fireRouteTableEvent(bucket, null, null, null, contact, RouteTable.RouteTableEvent.EventType.ADD_ACTIVE_CONTACT);
    }

    protected void fireCachedContactAdded(Bucket bucket, Contact contact, Contact contact2) {
        this.fireRouteTableEvent(bucket, null, null, contact, contact2, RouteTable.RouteTableEvent.EventType.ADD_CACHED_CONTACT);
    }

    protected void fireContactUpdate(Bucket bucket, Contact contact, Contact contact2) {
        this.fireRouteTableEvent(bucket, null, null, contact, contact2, RouteTable.RouteTableEvent.EventType.UPDATE_CONTACT);
    }

    protected void fireReplaceContact(Bucket bucket, Contact contact, Contact contact2) {
        this.fireRouteTableEvent(bucket, null, null, contact, contact2, RouteTable.RouteTableEvent.EventType.REPLACE_CONTACT);
    }

    protected void fireRemoveContact(Bucket bucket, Contact contact) {
        this.fireRouteTableEvent(bucket, null, null, null, contact, RouteTable.RouteTableEvent.EventType.REMOVE_CONTACT);
    }

    protected void fireContactCheck(Bucket bucket, Contact contact, Contact contact2) {
        this.fireRouteTableEvent(bucket, null, null, contact, contact2, RouteTable.RouteTableEvent.EventType.CONTACT_CHECK);
    }

    protected void fireSplitBucket(Bucket bucket, Bucket bucket2, Bucket bucket3) {
        this.fireRouteTableEvent(bucket, bucket2, bucket3, null, null, RouteTable.RouteTableEvent.EventType.SPLIT_BUCKET);
    }

    protected void fireClear() {
        this.fireRouteTableEvent(null, null, null, null, null, RouteTable.RouteTableEvent.EventType.CLEAR);
    }

    protected void fireRouteTableEvent(Bucket bucket, Bucket bucket2, Bucket bucket3, Contact contact, Contact contact2, RouteTable.RouteTableEvent.EventType eventType) {
        if (this.listeners.isEmpty()) {
            return;
        }
        final RouteTable.RouteTableEvent routeTableEvent = new RouteTable.RouteTableEvent(this, bucket, bucket2, bucket3, contact, contact2, eventType);
        Runnable runnable = new Runnable(){

            public void run() {
                for (RouteTable.RouteTableListener routeTableListener : RouteTableImpl.this.listeners) {
                    routeTableListener.handleRouteTableEvent(routeTableEvent);
                }
            }
        };
        DHTExecutorService dHTExecutorService = this.notifier;
        if (dHTExecutorService != null) {
            dHTExecutorService.executeSequentially(runnable);
        } else {
            runnable.run();
        }
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Local: ").append(this.getLocalNode()).append("\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Bucket bucket : this.getBuckets()) {
            stringBuilder.append(bucket).append("\n");
            for (Contact contact : bucket.getActiveContacts()) {
                if (contact.isShutdown()) {
                    ++n3;
                }
                if (contact.isAlive()) {
                    ++n;
                    continue;
                }
                if (contact.isDead()) {
                    ++n2;
                    continue;
                }
                ++n4;
            }
            for (Contact contact : bucket.getCachedContacts()) {
                if (contact.isShutdown()) {
                    ++n3;
                }
                if (contact.isAlive()) {
                    ++n;
                    continue;
                }
                if (contact.isDead()) {
                    ++n2;
                    continue;
                }
                ++n4;
            }
        }
        stringBuilder.append("Total Buckets: ").append(this.bucketTrie.size()).append("\n");
        stringBuilder.append("Total Active Contacts: ").append(this.getActiveContacts().size()).append("\n");
        stringBuilder.append("Total Cached Contacts: ").append(this.getCachedContacts().size()).append("\n");
        stringBuilder.append("Total Alive Contacts: ").append(n).append("\n");
        stringBuilder.append("Total Dead Contacts: ").append(n2).append("\n");
        stringBuilder.append("Total Down Contacts: ").append(n3).append("\n");
        stringBuilder.append("Total Unknown Contacts: ").append(n4).append("\n");
        return stringBuilder.toString();
    }
}

