/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ContactUtils;

public class LocalContact
implements Contact {
    private static final Log LOG = LogFactory.getLog(LocalContact.class);
    private static final long serialVersionUID = -1372388406248015059L;
    private volatile Vendor vendor;
    private volatile Version version;
    private volatile KUID nodeId;
    private volatile int instanceId;
    private volatile int flags;
    private volatile transient SocketAddress sourceAddress;
    private volatile transient SocketAddress contactAddress;
    private transient SocketAddress tmpExternalAddress;

    public LocalContact(Vendor vendor, Version version, KUID kUID, int n, boolean bl) {
        this(vendor, version, kUID, n, bl ? 1 : 0);
    }

    public LocalContact(Vendor vendor, Version version, KUID kUID, int n, int n2) {
        this.vendor = vendor;
        this.version = version;
        this.nodeId = kUID;
        this.instanceId = n;
        this.flags = n2;
        this.init();
    }

    private void init() {
        this.contactAddress = new InetSocketAddress("localhost", 0);
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setNodeID(KUID kUID) {
        this.nodeId = kUID;
    }

    public KUID getNodeID() {
        return this.nodeId;
    }

    public int getInstanceID() {
        return this.instanceId;
    }

    public int getFlags() {
        return this.flags;
    }

    public void nextInstanceID() {
        this.instanceId = (this.instanceId + 1) % 255;
    }

    public SocketAddress getContactAddress() {
        return this.contactAddress;
    }

    public synchronized void setContactAddress(SocketAddress socketAddress) {
        this.contactAddress = socketAddress;
        this.tmpExternalAddress = null;
    }

    public synchronized void setExternalPort(int n) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getContactAddress();
        this.setContactAddress(new InetSocketAddress(inetSocketAddress.getAddress(), n));
    }

    public int getExternalPort() {
        return ((InetSocketAddress)this.getContactAddress()).getPort();
    }

    public SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public synchronized void setSourceAddress(SocketAddress socketAddress) {
        this.sourceAddress = socketAddress;
    }

    public boolean isFirewalled() {
        return (this.flags & 1) != 0;
    }

    public void setFirewalled(boolean bl) {
        if (this.isFirewalled() != bl) {
            this.flags ^= 1;
        }
    }

    public synchronized boolean setExternalAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SocketAddress is null");
            }
            return false;
        }
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        InetAddress inetAddress2 = ((InetSocketAddress)this.getContactAddress()).getAddress();
        int n = ((InetSocketAddress)this.getContactAddress()).getPort();
        if (inetAddress.equals(inetAddress2)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Reported external address is equal to current external address: " + inetAddress));
            }
            return false;
        }
        if (ContactUtils.isPrivateAddress(inetAddress)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(inetAddress + " is a PRIVATE address"));
            }
            return false;
        }
        if (!NetworkUtils.isSameAddressSpace((InetAddress)inetAddress, (InetAddress)inetAddress2)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("The current external address " + inetAddress2 + " is from a different IP address space than " + inetAddress));
            }
            return false;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        if (this.tmpExternalAddress == null || this.tmpExternalAddress.equals(inetSocketAddress)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Setting the current external address from " + this.contactAddress + " to " + inetSocketAddress));
            }
            this.contactAddress = inetSocketAddress;
        }
        this.tmpExternalAddress = inetSocketAddress;
        return true;
    }

    public int getFailures() {
        return 0;
    }

    public long getLastFailedTime() {
        return 0L;
    }

    public void setRoundTripTime(long l) {
    }

    public long getRoundTripTime() {
        return 0L;
    }

    public void setTimeStamp(long l) {
    }

    public long getTimeStamp() {
        return Long.MAX_VALUE;
    }

    public long getAdaptativeTimeout() {
        return 0L;
    }

    public void handleFailure() {
    }

    public boolean hasBeenRecentlyAlive() {
        return true;
    }

    public boolean hasFailed() {
        return false;
    }

    public boolean isAlive() {
        return false;
    }

    public boolean isDead() {
        return false;
    }

    public boolean isUnknown() {
        return true;
    }

    public void unknown() {
    }

    public boolean isShutdown() {
        return (this.flags & 2) != 0;
    }

    public void shutdown(boolean bl) {
        if (this.isShutdown() != bl) {
            this.flags ^= 2;
        }
    }

    public void updateWithExistingContact(Contact contact) {
        if (contact != this) {
            throw new UnsupportedOperationException();
        }
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LocalContact)) {
            return false;
        }
        return this.nodeId.equals(((Contact)object).getNodeID());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ContactUtils.toString(this.getNodeID(), this.getContactAddress())).append(", instanceId=").append(this.getInstanceID()).append(", firewalled=").append(this.isFirewalled());
        return stringBuilder.toString();
    }
}

