/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.net.SocketAddress;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.routing.impl.RemoteContact;

public class ContactFactory {
    private ContactFactory() {
    }

    public static Contact createLocalContact(Vendor vendor, Version version, boolean bl) {
        return ContactFactory.createLocalContact(vendor, version, KUID.createRandomID(), 0, bl);
    }

    public static Contact createLocalContact(Vendor vendor, Version version, KUID kUID, int n, boolean bl) {
        return new LocalContact(vendor, version, kUID, n, bl);
    }

    public static Contact createLiveContact(SocketAddress socketAddress, Vendor vendor, Version version, KUID kUID, SocketAddress socketAddress2, int n, int n2) {
        return new RemoteContact(socketAddress, vendor, version, kUID, socketAddress2, n, n2, Contact.State.ALIVE);
    }

    public static Contact createUnknownContact(Vendor vendor, Version version, KUID kUID, SocketAddress socketAddress) {
        return new RemoteContact(null, vendor, version, kUID, socketAddress, 0, 0, Contact.State.UNKNOWN);
    }

    public static Contact createUnknownContact(SocketAddress socketAddress, Vendor vendor, Version version, KUID kUID, SocketAddress socketAddress2, int n, int n2) {
        return new RemoteContact(socketAddress, vendor, version, kUID, socketAddress2, n, n2, Contact.State.UNKNOWN);
    }
}

