/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.result;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindValueResult
extends LookupResult {
    private final EntityKey lookupKey;
    private final Map<? extends Contact, ? extends SecurityToken> path;
    private final long time;
    private final int hop;
    private final Collection<? extends DHTValueEntity> entities;
    private final Collection<? extends EntityKey> entityKeys;

    public FindValueResult(EntityKey entityKey, Map<? extends Contact, ? extends SecurityToken> map, Collection<? extends DHTValueEntity> collection, Collection<? extends EntityKey> collection2, long l, int n) {
        super(entityKey.getPrimaryKey());
        this.lookupKey = entityKey;
        this.path = map;
        this.time = l;
        this.hop = n;
        this.entities = new CopyOnWriteArrayList<DHTValueEntity>(collection);
        this.entityKeys = new CopyOnWriteArrayList<EntityKey>(collection2);
    }

    public EntityKey getLookupKey() {
        return this.lookupKey;
    }

    @Override
    public Collection<? extends Contact> getPath() {
        return this.path.keySet();
    }

    @Override
    public SecurityToken getSecurityToken(Contact contact) {
        return this.path.get(contact);
    }

    @Override
    public Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> getEntryPath() {
        return this.path.entrySet();
    }

    public Collection<? extends DHTValueEntity> getEntities() {
        return this.entities;
    }

    public Collection<? extends EntityKey> getEntityKeys() {
        return this.entityKeys;
    }

    public long getTime() {
        return this.time;
    }

    public int getHop() {
        return this.hop;
    }

    public boolean isSuccess() {
        return !this.entities.isEmpty() || !this.entityKeys.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLookupID()).append(" (time=").append(this.time).append("ms, hop=").append(this.hop).append(")\n");
        if (!this.isSuccess()) {
            stringBuilder.append("No values found!");
            return stringBuilder.toString();
        }
        stringBuilder.append(CollectionUtils.toString(this.entities));
        stringBuilder.append(CollectionUtils.toString(this.entityKeys));
        return stringBuilder.toString();
    }
}

