/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreRequestImpl
extends AbstractRequestMessage
implements StoreRequest {
    private final SecurityToken securityToken;
    private final Collection<? extends DHTValueEntity> values;

    public StoreRequestImpl(Context context, Contact contact, MessageID messageID, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        super(context, DHTMessage.OpCode.STORE_REQUEST, contact, messageID, Version.ZERO);
        this.securityToken = securityToken;
        this.values = collection;
    }

    public StoreRequestImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.STORE_REQUEST, socketAddress, messageID, version, messageInputStream);
        this.securityToken = messageInputStream.readSecurityToken();
        this.values = messageInputStream.readDHTValueEntities(this.getContact(), context.getDHTValueFactoryManager());
    }

    @Override
    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public Collection<? extends DHTValueEntity> getDHTValueEntities() {
        return this.values;
    }

    @Override
    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeSecurityToken(this.securityToken);
        messageOutputStream.writeDHTValueEntities(this.values);
    }

    public String toString() {
        return "StoreRequest: " + this.values;
    }
}

