/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import java.io.Serializable;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.messages.ResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StoreResponse
extends ResponseMessage {
    public static final StatusCode OK = StatusCode.valueOf(1, "OK");
    public static final StatusCode ERROR = StatusCode.valueOf(2, "ERROR");

    public Collection<StoreStatusCode> getStoreStatusCodes();

    public static final class StoreStatusCode
    implements Serializable {
        private static final long serialVersionUID = -3753019724686307068L;
        private final KUID primaryKey;
        private final KUID secondaryKey;
        private final StatusCode statusCode;

        public StoreStatusCode(DHTValueEntity dHTValueEntity, StatusCode statusCode) {
            this(dHTValueEntity.getPrimaryKey(), dHTValueEntity.getSecondaryKey(), statusCode);
        }

        public StoreStatusCode(KUID kUID, KUID kUID2, StatusCode statusCode) {
            this.primaryKey = kUID;
            this.secondaryKey = kUID2;
            this.statusCode = statusCode;
        }

        public boolean isFor(DHTValueEntity dHTValueEntity) {
            return this.primaryKey.equals(dHTValueEntity.getPrimaryKey()) && this.secondaryKey.equals(dHTValueEntity.getSecondaryKey());
        }

        public KUID getPrimaryKey() {
            return this.primaryKey;
        }

        public KUID getSecondaryKey() {
            return this.secondaryKey;
        }

        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        public int hashCode() {
            return this.primaryKey.hashCode() ^ this.secondaryKey.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StoreStatusCode)) {
                return false;
            }
            StoreStatusCode storeStatusCode = (StoreStatusCode)object;
            return this.primaryKey.equals(storeStatusCode.primaryKey) && this.secondaryKey.equals(storeStatusCode.secondaryKey) && this.statusCode.equals(storeStatusCode.statusCode);
        }

        public String toString() {
            return "PrimaryKey=" + this.primaryKey + ", secondaryKey=" + this.secondaryKey + ", statusCode=" + this.statusCode;
        }
    }
}

