/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.BootstrapProcess;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.routing.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapManager
extends AbstractManager<BootstrapResult> {
    private BootstrapFuture future = null;
    private boolean bootstrapped = false;

    public BootstrapManager(Context context) {
        super(context);
    }

    public synchronized boolean isBootstrapped() {
        return this.bootstrapped;
    }

    public synchronized void setBootstrapped(boolean bl) {
        this.bootstrapped = bl;
    }

    public synchronized boolean isBootstrapping() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BootstrapFuture bootstrapFuture;
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            bootstrapFuture = this.future;
            this.future = null;
        }
        if (bootstrapFuture != null) {
            bootstrapFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTFuture<BootstrapResult> bootstrap(Contact contact) {
        if (contact == null) {
            throw new NullPointerException("Contact is null");
        }
        if (contact.equals(this.context.getLocalNode())) {
            throw new IllegalArgumentException("Cannot bootstrap from local Node");
        }
        this.stop();
        BootstrapProcess bootstrapProcess = new BootstrapProcess(this.context, this, contact);
        BootstrapFuture bootstrapFuture = new BootstrapFuture(bootstrapProcess);
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            this.future = bootstrapFuture;
        }
        this.context.getDHTExecutorService().execute((Runnable)((Object)bootstrapFuture));
        return bootstrapFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTFuture<BootstrapResult> bootstrap(Set<? extends SocketAddress> set) {
        if (set == null) {
            throw new NullPointerException("Set<SocketAddress> is null");
        }
        this.stop();
        BootstrapProcess bootstrapProcess = new BootstrapProcess(this.context, this, set);
        BootstrapFuture bootstrapFuture = new BootstrapFuture(bootstrapProcess);
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            this.future = bootstrapFuture;
        }
        this.context.getDHTExecutorService().execute((Runnable)((Object)bootstrapFuture));
        return bootstrapFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BootstrapFuture
    extends DHTFutureTask<BootstrapResult> {
        public BootstrapFuture(DHTTask<BootstrapResult> dHTTask) {
            super(BootstrapManager.this.context, dHTTask);
        }

        @Override
        protected void done0() {
            BootstrapManager.this.stop();
        }
    }
}

