/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTBadResponseException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.PingSettings;
import org.limewire.mojito.util.ContactUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingResponseHandler
extends AbstractResponseHandler<PingResult> {
    private static final Log LOG = LogFactory.getLog(PingResponseHandler.class);
    private int parallelism;
    private int maxParallelPingFailures;
    private final Contact sender;
    private int active = 0;
    private int failures = 0;
    private final PingIterator pinger;

    public PingResponseHandler(Context context, PingIterator pingIterator) {
        this(context, null, pingIterator);
    }

    public PingResponseHandler(Context context, Contact contact, PingIterator pingIterator) {
        super(context);
        this.sender = contact;
        this.pinger = pingIterator;
        this.setParallelism(-1);
        this.setMaxParallelPingFailures(-1);
    }

    public void setParallelism(int n) {
        if (n < 0) {
            this.parallelism = PingSettings.PARALLEL_PINGS.getValue();
        } else if (n > 0) {
            this.parallelism = n;
        } else {
            throw new IllegalArgumentException("parallelism=" + n);
        }
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setMaxParallelPingFailures(int n) {
        this.maxParallelPingFailures = n < 0 ? PingSettings.MAX_PARALLEL_PING_FAILURES.getValue() : n;
    }

    public int getMaxParallelPingFailures() {
        return this.maxParallelPingFailures;
    }

    @Override
    protected void start() throws DHTException {
        if (!this.pinger.hasNext()) {
            throw new DHTException("No hosts to ping");
        }
        try {
            this.pingNextAndThrowIfDone(new DHTException("All SocketAddresses were invalid and there are no Hosts left to Ping: " + this.context.getLocalNode() + "; " + this.pinger));
        }
        catch (IOException iOException) {
            throw new DHTException(iOException);
        }
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        this.decrementActive();
        PingResponse pingResponse = (PingResponse)responseMessage;
        Contact contact = pingResponse.getContact();
        SocketAddress socketAddress = pingResponse.getExternalAddress();
        BigInteger bigInteger = pingResponse.getEstimatedSize();
        if (contact.getContactAddress().equals(socketAddress)) {
            this.pingNextAndThrowIfDone(new DHTBadResponseException(contact + " is trying to set our external address to its address!"));
            return;
        }
        if (this.context.isLocalNodeID(contact.getNodeID())) {
            if (this.sender == null) {
                this.pingNextAndThrowIfDone(new DHTBadResponseException(contact + " is trying to spoof our Node ID"));
            } else {
                this.setReturnValue(new PingResult(contact, socketAddress, bigInteger, l));
            }
            return;
        }
        this.context.setExternalAddress(socketAddress);
        this.context.addEstimatedRemoteSize(bigInteger);
        this.setReturnValue(new PingResult(contact, socketAddress, bigInteger, l));
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        this.decrementActive();
        this.incrementFailures();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Timeout: " + ContactUtils.toString(kUID, socketAddress)));
        }
        if (this.giveUp()) {
            if (!this.hasActive()) {
                this.fireTimeoutException(kUID, socketAddress, requestMessage, l);
            }
        } else {
            this.pingNextAndThrowIfDone(this.createTimeoutException(kUID, socketAddress, requestMessage, l));
        }
    }

    @Override
    protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        this.decrementActive();
        this.incrementFailures();
        if (iOException instanceof SocketException && !this.giveUp()) {
            try {
                this.timeout(kUID, socketAddress, requestMessage, -1L);
            }
            catch (IOException iOException2) {
                LOG.error((Object)"IOException", (Throwable)iOException2);
                if (!this.pinger.hasNext()) {
                    this.setException(new DHTException(iOException2));
                }
            }
        } else {
            this.setException(new DHTBackendException(kUID, socketAddress, requestMessage, iOException));
        }
    }

    private void pingNextAndThrowIfDone(DHTException dHTException) throws IOException {
        while (this.pinger.hasNext() && this.canMore()) {
            if (!this.pinger.pingNext(this.context, this)) continue;
            this.incrementActive();
        }
        if (!this.hasActive()) {
            this.setException(dHTException);
        }
    }

    private void decrementActive() {
        --this.active;
    }

    private void incrementActive() {
        ++this.active;
    }

    private void incrementFailures() {
        ++this.failures;
    }

    private boolean canMore() {
        return this.active < this.getParallelism();
    }

    private boolean hasActive() {
        return this.active > 0;
    }

    private boolean giveUp() {
        return !this.pinger.hasNext() || this.failures >= this.getMaxParallelPingFailures();
    }

    public static interface PingIterator {
        public boolean hasNext();

        public boolean pingNext(Context var1, PingResponseHandler var2) throws IOException;
    }
}

